/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.server.internal.monitoring.ExecutionStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.MonitoringUtils;
import org.glassfish.jersey.server.internal.monitoring.ResourceMethodStatisticsImpl;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.ResourceMethodStatistics;
import org.glassfish.jersey.server.monitoring.ResourceStatistics;

final class ResourceStatisticsImpl
implements ResourceStatistics {
    private final Map<ResourceMethod, ResourceMethodStatistics> resourceMethods;
    private final ExecutionStatistics resourceExecutionStatistics;
    private final ExecutionStatistics requestExecutionStatistics;

    private ResourceStatisticsImpl(Map<ResourceMethod, ResourceMethodStatistics> resourceMethods, ExecutionStatistics resourceExecutionStatistics, ExecutionStatistics requestExecutionStatistics) {
        this.resourceMethods = resourceMethods;
        this.resourceExecutionStatistics = resourceExecutionStatistics;
        this.requestExecutionStatistics = requestExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getResourceMethodExecutionStatistics() {
        return this.resourceExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getRequestExecutionStatistics() {
        return this.requestExecutionStatistics;
    }

    @Override
    public Map<ResourceMethod, ResourceMethodStatistics> getResourceMethodStatistics() {
        return this.resourceMethods;
    }

    @Override
    public ResourceStatistics snapshot() {
        return this;
    }

    static class Builder {
        private final Set<ResourceMethodStatisticsImpl.Builder> methodsBuilders = new HashSet<ResourceMethodStatisticsImpl.Builder>();
        private final ResourceMethodStatisticsImpl.Factory methodFactory;
        private ExecutionStatisticsImpl.Builder resourceExecutionStatisticsBuilder;
        private ExecutionStatisticsImpl.Builder requestExecutionStatisticsBuilder;
        private ResourceStatisticsImpl cached;

        Builder(Resource resource, ResourceMethodStatisticsImpl.Factory methodFactory) {
            this(methodFactory);
            for (ResourceMethod method : resource.getResourceMethods()) {
                this.getOrCreate(method);
            }
        }

        Builder(ResourceMethodStatisticsImpl.Factory methodFactory) {
            this.methodFactory = methodFactory;
        }

        ResourceStatisticsImpl build() {
            Object stats;
            if (this.cached != null) {
                return this.cached;
            }
            HashMap resourceMethods = Maps.newHashMap();
            for (ResourceMethodStatisticsImpl.Builder builder : this.methodsBuilders) {
                stats = builder.build();
                resourceMethods.put(((ResourceMethodStatisticsImpl)stats).getResourceMethod(), stats);
            }
            ExecutionStatistics resourceStats = this.resourceExecutionStatisticsBuilder == null ? ExecutionStatisticsImpl.EMPTY : this.resourceExecutionStatisticsBuilder.build();
            ExecutionStatistics requestStats = this.requestExecutionStatisticsBuilder == null ? ExecutionStatisticsImpl.EMPTY : this.requestExecutionStatisticsBuilder.build();
            stats = new ResourceStatisticsImpl(Collections.unmodifiableMap(resourceMethods), resourceStats, requestStats);
            if (MonitoringUtils.isCacheable(requestStats)) {
                this.cached = stats;
            }
            return stats;
        }

        void addExecution(ResourceMethod resourceMethod, long methodStartTime, long methodDuration, long requestStartTime, long requestDuration) {
            this.cached = null;
            if (this.resourceExecutionStatisticsBuilder == null) {
                this.resourceExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            }
            this.resourceExecutionStatisticsBuilder.addExecution(methodStartTime, methodDuration);
            if (this.requestExecutionStatisticsBuilder == null) {
                this.requestExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            }
            this.requestExecutionStatisticsBuilder.addExecution(requestStartTime, requestDuration);
            this.addMethod(resourceMethod);
        }

        void addMethod(ResourceMethod resourceMethod) {
            this.getOrCreate(resourceMethod);
        }

        private ResourceMethodStatisticsImpl.Builder getOrCreate(ResourceMethod resourceMethod) {
            ResourceMethodStatisticsImpl.Builder methodStats = this.methodFactory.getOrCreate(resourceMethod);
            if (!this.methodsBuilders.contains(methodStats)) {
                this.methodsBuilders.add(methodStats);
            }
            return methodStats;
        }
    }
}

