/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.statemodel;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.AbstractHelixLeaderStandbyStateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.view.aggregator.HelixViewAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StateModelInfo(initialState="OFFLINE", states={"LEADER", "STANDBY"})
public class DistViewAggregatorStateModel
extends AbstractHelixLeaderStandbyStateModel {
    private static final Logger logger = LoggerFactory.getLogger(DistViewAggregatorStateModel.class);
    private HelixViewAggregator _aggregator;

    public DistViewAggregatorStateModel(String zkAddr) {
        super(zkAddr);
    }

    public void onBecomeStandbyFromOffline(Message message, NotificationContext context) {
        this.logStateTransition("OFFLINE", "STANDBY", message.getPartitionName(), message.getTgtName());
    }

    public void onBecomeLeaderFromStandby(Message message, NotificationContext context) throws Exception {
        String viewClusterName = message.getPartitionName();
        if (this._aggregator != null) {
            logger.warn("Aggregator already exists for view cluster {}: {}: cleaning it up.", (Object)viewClusterName, (Object)this._aggregator.getAggregatorInstanceName());
            this.reset();
        }
        logger.info("Creating new HelixViewAggregator for view cluster {}", (Object)viewClusterName);
        try {
            this._aggregator = new HelixViewAggregator(viewClusterName, this._zkAddr);
            this._aggregator.start();
        }
        catch (Exception e) {
            logger.error("Aggregator failed to become leader from stand by for view cluster {}", (Object)viewClusterName, (Object)e);
            this.reset();
            throw e;
        }
        this.logStateTransition("STANDBY", "LEADER", message.getPartitionName(), message.getTgtName());
    }

    public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
        this.reset();
        this.logStateTransition("LEADER", "STANDBY", message.getPartitionName(), message.getTgtName());
    }

    public void onBecomeOfflineFromStandby(Message message, NotificationContext context) {
        this.logStateTransition("OFFLINE", "DROPPED", message.getPartitionName(), message.getTgtName());
    }

    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
        this.logStateTransition("OFFLINE", "DROPPED", message.getPartitionName(), message.getTgtName());
    }

    public void reset() {
        if (this._aggregator != null) {
            logger.info("Resetting view aggregator {}", (Object)this._aggregator.getAggregatorInstanceName());
            this._aggregator.shutdown();
            this._aggregator = null;
        }
    }

    public String getStateModeInstanceDescription(String partitionName, String instanceName) {
        return String.format("View Aggregator (%s) for view cluster %s", instanceName, partitionName);
    }
}

