/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ControllerHistory
extends HelixProperty {
    private static final int HISTORY_SIZE = 10;
    private static final int MAINTENANCE_HISTORY_SIZE = 20;

    public ControllerHistory(String id) {
        super(id);
    }

    public ControllerHistory(ZNRecord record) {
        super(record);
    }

    public ZNRecord updateHistory(String clusterName, String instanceName, String version) {
        List<String> list = this._record.getListField(clusterName);
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(clusterName, list);
        }
        while (list.size() >= 10) {
            list.remove(0);
        }
        list.add(instanceName);
        HashMap<String, String> historyEntry = new HashMap<String, String>();
        long currentTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(currentTime));
        historyEntry.put(ConfigProperty.CONTROLLER.name(), instanceName);
        historyEntry.put(ConfigProperty.TIME.name(), String.valueOf(currentTime));
        historyEntry.put(ConfigProperty.DATE.name(), dateTime);
        historyEntry.put(ConfigProperty.VERSION.name(), version);
        return this.populateHistoryEntries(HistoryType.CONTROLLER_LEADERSHIP, ((Object)historyEntry).toString());
    }

    public List<String> getHistoryList() {
        List<String> historyList = this._record.getListField(ConfigProperty.HISTORY.name());
        if (historyList == null) {
            historyList = new ArrayList<String>();
        }
        return historyList;
    }

    public List<String> getManagementModeHistory() {
        List<String> history = this._record.getListField(ManagementModeConfigKey.MANAGEMENT_MODE_HISTORY.name());
        return history == null ? Collections.emptyList() : history;
    }

    public ZNRecord updateManagementModeHistory(String controller, ClusterManagementMode mode, String fromHost, long time, String reason) {
        HashMap<String, String> historyEntry = new HashMap<String, String>();
        historyEntry.put(ConfigProperty.CONTROLLER.name(), controller);
        historyEntry.put(ConfigProperty.TIME.name(), Instant.ofEpochMilli(time).toString());
        historyEntry.put(ManagementModeConfigKey.MODE.name(), mode.getMode().name());
        historyEntry.put(ManagementModeConfigKey.STATUS.name(), mode.getStatus().name());
        if (fromHost != null) {
            historyEntry.put(PauseSignal.PauseSignalProperty.FROM_HOST.name(), fromHost);
        }
        if (reason != null) {
            historyEntry.put(PauseSignal.PauseSignalProperty.REASON.name(), reason);
        }
        return this.populateHistoryEntries(HistoryType.MANAGEMENT_MODE, ((Object)historyEntry).toString());
    }

    public ZNRecord updateMaintenanceHistory(boolean enabled, String reason, long currentTime, MaintenanceSignal.AutoTriggerReason internalReason, Map<String, String> customFields, MaintenanceSignal.TriggeringEntity triggeringEntity) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(currentTime));
        HashMap<String, String> maintenanceEntry = new HashMap<String, String>();
        maintenanceEntry.put(MaintenanceConfigKey.OPERATION_TYPE.name(), enabled ? OperationType.ENTER.name() : OperationType.EXIT.name());
        maintenanceEntry.put(MaintenanceConfigKey.REASON.name(), reason);
        maintenanceEntry.put(MaintenanceConfigKey.DATE.name(), dateTime);
        maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.TIMESTAMP.name(), String.valueOf(currentTime));
        maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.TRIGGERED_BY.name(), triggeringEntity.name());
        if (triggeringEntity == MaintenanceSignal.TriggeringEntity.CONTROLLER) {
            maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.AUTO_TRIGGER_REASON.name(), internalReason.name());
        } else if (customFields != null && !customFields.isEmpty()) {
            for (Map.Entry<String, String> customFieldEntry : customFields.entrySet()) {
                if (maintenanceEntry.containsKey(customFieldEntry.getKey())) continue;
                maintenanceEntry.put(customFieldEntry.getKey(), customFieldEntry.getValue());
            }
        }
        return this.populateHistoryEntries(HistoryType.MAINTENANCE, new ObjectMapper().writeValueAsString(maintenanceEntry));
    }

    private ZNRecord populateHistoryEntries(HistoryType type, String entry) {
        int historySize;
        String configKey;
        switch (type) {
            case CONTROLLER_LEADERSHIP: {
                configKey = ConfigProperty.HISTORY.name();
                historySize = 10;
                break;
            }
            case MAINTENANCE: {
                configKey = MaintenanceConfigKey.MAINTENANCE_HISTORY.name();
                historySize = 20;
                break;
            }
            case MANAGEMENT_MODE: {
                configKey = ManagementModeConfigKey.MANAGEMENT_MODE_HISTORY.name();
                historySize = 10;
                break;
            }
            default: {
                throw new HelixException("Unknown history type " + type.name());
            }
        }
        List<String> historyList = this._record.getListField(configKey);
        if (historyList == null) {
            historyList = new ArrayList<String>();
            this._record.setListField(configKey, historyList);
        }
        while (historyList.size() >= historySize) {
            historyList.remove(0);
        }
        historyList.add(entry);
        return this._record;
    }

    public List<String> getMaintenanceHistoryList() {
        List<String> maintenanceHistoryList = this._record.getListField(MaintenanceConfigKey.MAINTENANCE_HISTORY.name());
        if (maintenanceHistoryList == null) {
            maintenanceHistoryList = new ArrayList<String>();
        }
        return maintenanceHistoryList;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum HistoryType {
        CONTROLLER_LEADERSHIP,
        MAINTENANCE,
        MANAGEMENT_MODE;

    }

    private static enum OperationType {
        ENTER,
        EXIT;

    }

    private static enum ManagementModeConfigKey {
        MANAGEMENT_MODE_HISTORY,
        MODE,
        STATUS;

    }

    private static enum MaintenanceConfigKey {
        MAINTENANCE_HISTORY,
        OPERATION_TYPE,
        DATE,
        REASON;

    }

    private static enum ConfigProperty {
        HISTORY,
        TIME,
        DATE,
        VERSION,
        CONTROLLER;

    }
}

