/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.datamodel.serializer;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.introspect.CodehausJacksonIntrospector;
import org.apache.helix.zookeeper.util.GZipCompressionUtil;
import org.apache.helix.zookeeper.util.ZNRecordUtil;
import org.apache.helix.zookeeper.zkclient.exception.ZkMarshallingError;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZNRecordSerializer
implements ZkSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ZNRecordSerializer.class);
    private static ObjectMapper mapper = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new CodehausJacksonIntrospector());

    private static int getListFieldBound(ZNRecord record) {
        int max = Integer.MAX_VALUE;
        if (record.getSimpleFields().containsKey("listField.bound")) {
            String maxStr = record.getSimpleField("listField.bound");
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (Exception e) {
                LOG.error("IllegalNumberFormat for list field bound: " + maxStr);
            }
        }
        return max;
    }

    @Override
    public byte[] serialize(Object data) {
        byte[] serializedBytes;
        if (!(data instanceof ZNRecord)) {
            LOG.error("Input object must be of type ZNRecord but it is " + data + ". Will not write to zk");
            throw new ZkMarshallingError("Input object is not of type ZNRecord (was " + data + ")");
        }
        ZNRecord record = (ZNRecord)data;
        int max = ZNRecordSerializer.getListFieldBound(record);
        if (max < Integer.MAX_VALUE) {
            Map<String, List<String>> listMap = record.getListFields();
            for (String key : listMap.keySet()) {
                List<String> list = listMap.get(key);
                if (list.size() <= max) continue;
                listMap.put(key, list.subList(0, max));
            }
        }
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        mapper.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean isCompressed = false;
        try {
            mapper.writeValue((OutputStream)baos, data);
            serializedBytes = baos.toByteArray();
            if (ZNRecordUtil.shouldCompress(record, serializedBytes.length)) {
                serializedBytes = GZipCompressionUtil.compress(serializedBytes);
                isCompressed = true;
            }
        }
        catch (Exception e) {
            LOG.error("Exception during data serialization. ZNRecord ID: {} will not be written to zk.", (Object)record.getId(), (Object)e);
            throw new ZkMarshallingError(e);
        }
        int writeSizeLimit = ZNRecordUtil.getSerializerWriteSizeLimit();
        if (serializedBytes.length > writeSizeLimit) {
            LOG.error("Data size: {} is greater than {} bytes, is compressed: {}, ZNRecord.id: {}. Data will not be written to Zookeeper.", new Object[]{serializedBytes.length, writeSizeLimit, isCompressed, record.getId()});
            throw new ZkMarshallingError("Data size: " + serializedBytes.length + " is greater than " + writeSizeLimit + " bytes, is compressed: " + isCompressed + ", ZNRecord.id: " + record.getId());
        }
        return serializedBytes;
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            if (GZipCompressionUtil.isCompressed(bytes)) {
                byte[] uncompressedBytes = GZipCompressionUtil.uncompress(bais);
                bais = new ByteArrayInputStream(uncompressedBytes);
            }
            return mapper.readValue((InputStream)bais, ZNRecord.class);
        }
        catch (Exception e) {
            LOG.error("Exception during deserialization of bytes: {}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }
}

