/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateModelsResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(StateModelsResource.class);

    public StateModelsResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            presentation = this.getStateModelsRepresentation();
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getStateModelsRepresentation() throws JsonGenerationException, JsonMappingException, IOException {
        String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
        List models = setupTool.getClusterManagementTool().getStateModelDefs(clusterName);
        ZNRecord modelDefinitions = new ZNRecord("modelDefinitions");
        modelDefinitions.setListField("models", models);
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(modelDefinitions), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (!command.equalsIgnoreCase("addStateModelDef")) {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addStateModelDef" + "]");
            }
            ZNRecord newStateModel = jsonParameters.getExtraParameter("newStateModelDef");
            HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
            accessor.setProperty(accessor.keyBuilder().stateModelDef(newStateModel.getId()), (HelixProperty)new StateModelDefinition(newStateModel));
            this.getResponse().setEntity((Representation)this.getStateModelsRepresentation());
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }
}

