/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.ParticipantStateCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedStateCache
extends ParticipantStateCache<CustomizedState> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CurrentStateCache.class.getName());
    private Set<String> _aggregationEnabledTypes;

    public CustomizedStateCache(String clusterName, Set<String> aggregationEnabledTypes) {
        this(CustomizedStateCache.createDefaultControlContextProvider(clusterName), aggregationEnabledTypes);
    }

    public CustomizedStateCache(ControlContextProvider contextProvider, Set<String> aggregationEnabledTypes) {
        super(contextProvider);
        this._aggregationEnabledTypes = aggregationEnabledTypes;
    }

    @Override
    protected Set<PropertyKey> PopulateParticipantKeys(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        HashSet<PropertyKey> participantStateKeys = new HashSet<PropertyKey>();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String instanceName : liveInstanceMap.keySet()) {
            for (String customizedStateType : this._aggregationEnabledTypes) {
                accessor.getChildNames(keyBuilder.customizedStates(instanceName, customizedStateType)).stream().forEach(resourceName -> participantStateKeys.add(keyBuilder.customizedState(instanceName, customizedStateType, (String)resourceName)));
            }
        }
        return participantStateKeys;
    }

    public void setAggregationEnabledTypes(Set<String> aggregationEnabledTypes) {
        this._aggregationEnabledTypes = aggregationEnabledTypes;
    }
}

