/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.helix.zookeeper.zkclient.ZkClient;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkEventThread
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger(ZkClient.class);
    private BlockingQueue<ZkEvent> _events = new LinkedBlockingQueue<ZkEvent>();
    private long _totalEventCount = 0L;
    private long _totalEventCountHandled = 0L;
    private static AtomicInteger _eventId = new AtomicInteger(0);

    ZkEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkClient event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                }
                try {
                    zkEvent.run();
                    ++this._totalEventCountHandled;
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (Throwable e) {
                    LOG.error("Error handling event " + zkEvent, e);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
        LOG.info("Terminate ZkClient event thread.");
    }

    public void send(ZkEvent event) {
        if (!this.isInterrupted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("New event: " + event);
            }
            this._events.add(event);
            ++this._totalEventCount;
        }
    }

    public long getPendingEventsCount() {
        return this._events.size();
    }

    public long getTotalEventCount() {
        return this._totalEventCount;
    }

    public long getTotalHandledEventCount() {
        return this._totalEventCountHandled;
    }

    public static abstract class ZkEvent {
        private final String _description;
        private final String _sessionId;

        public ZkEvent(String description) {
            this(description, null);
        }

        ZkEvent(String description, String sessionId) {
            this._description = description;
            this._sessionId = sessionId;
        }

        public abstract void run() throws Exception;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ZkEvent[description: ").append(this._description);
            if (this._sessionId != null) {
                sb.append("; session: ").append(this._sessionId);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

