/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.logging.Level;
import java.util.logging.LogManager;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.log.IdentClient;
import org.restlet.engine.log.LogFilter;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Template;
import org.restlet.service.Service;

public class LogService
extends Service {
    private volatile boolean debugging;
    private volatile boolean identityCheck = false;
    private volatile Template loggableTemplate = null;
    private volatile String loggerName = null;
    private volatile Reference logPropertiesRef = null;
    private volatile String responseLogFormat = null;
    protected volatile Template responseLogTemplate;

    public LogService() {
        this(true);
    }

    public LogService(boolean enabled) {
        super(enabled);
    }

    @Override
    public Filter createInboundFilter(Context context) {
        return new LogFilter(context, this);
    }

    protected String getDefaultResponseLogMessage(Response response, int duration) {
        StringBuilder sb = new StringBuilder();
        Request request = response.getRequest();
        long currentTime = System.currentTimeMillis();
        sb.append(String.format("%tF", currentTime));
        sb.append('\t');
        sb.append(String.format("%tT", currentTime));
        sb.append('\t');
        String clientAddress = request.getClientInfo().getUpstreamAddress();
        sb.append(clientAddress == null ? "-" : clientAddress);
        sb.append('\t');
        if (this.isIdentityCheck()) {
            IdentClient ic = new IdentClient(request.getClientInfo().getUpstreamAddress(), request.getClientInfo().getPort(), response.getServerInfo().getPort());
            sb.append(ic.getUserIdentifier() == null ? "-" : ic.getUserIdentifier());
        } else if (request.getChallengeResponse() != null && request.getChallengeResponse().getIdentifier() != null) {
            sb.append(request.getChallengeResponse().getIdentifier());
        } else {
            sb.append('-');
        }
        sb.append('\t');
        String serverAddress = response.getServerInfo().getAddress();
        sb.append(serverAddress == null ? "-" : serverAddress);
        sb.append('\t');
        Integer serverport = response.getServerInfo().getPort();
        sb.append(serverport == null ? "-" : serverport.toString());
        sb.append('\t');
        String methodName = request.getMethod() == null ? "-" : request.getMethod().getName();
        sb.append(methodName == null ? "-" : methodName);
        sb.append('\t');
        String resourcePath = request.getResourceRef() == null ? "-" : request.getResourceRef().getPath();
        sb.append(resourcePath == null ? "-" : resourcePath);
        sb.append('\t');
        String resourceQuery = request.getResourceRef() == null ? "-" : request.getResourceRef().getQuery();
        sb.append(resourceQuery == null ? "-" : resourceQuery);
        sb.append('\t');
        sb.append(response.getStatus() == null ? "-" : Integer.toString(response.getStatus().getCode()));
        sb.append('\t');
        if (!response.isEntityAvailable() || Status.REDIRECTION_NOT_MODIFIED.equals(response.getStatus()) || Status.SUCCESS_NO_CONTENT.equals(response.getStatus()) || Method.HEAD.equals(request.getMethod())) {
            sb.append('0');
        } else {
            sb.append(response.getEntity().getSize() == -1L ? "-" : Long.toString(response.getEntity().getSize()));
        }
        sb.append('\t');
        try {
            if (request.getEntity() == null) {
                sb.append('0');
            } else {
                sb.append(request.getEntity().getSize() == -1L ? "-" : Long.toString(request.getEntity().getSize()));
            }
        }
        catch (Throwable t) {
            Engine.getLogger(LogService.class).log(Level.SEVERE, "Cannot retrieve size of request's entity", t);
            sb.append("-");
        }
        sb.append('\t');
        sb.append(duration);
        sb.append('\t');
        sb.append(request.getHostRef() == null ? "-" : request.getHostRef().toString());
        sb.append('\t');
        String agentName = request.getClientInfo().getAgent();
        sb.append(agentName == null ? "-" : agentName);
        sb.append('\t');
        sb.append(request.getReferrerRef() == null ? "-" : request.getReferrerRef().getIdentifier());
        return sb.toString();
    }

    public Template getLoggableTemplate() {
        return this.loggableTemplate;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Reference getLogPropertiesRef() {
        return this.logPropertiesRef;
    }

    public String getResponseLogFormat() {
        return this.responseLogFormat;
    }

    public String getResponseLogMessage(Response response, int duration) {
        String result = null;
        result = this.responseLogTemplate != null ? this.responseLogTemplate.format(response.getRequest(), response) : this.getDefaultResponseLogMessage(response, duration);
        return result;
    }

    @Deprecated
    protected boolean isDebugging() {
        return this.debugging;
    }

    public boolean isIdentityCheck() {
        return this.identityCheck;
    }

    public boolean isLoggable(Request request) {
        return this.getLoggableTemplate() == null ? true : this.getLoggableTemplate().match(request.getResourceRef().getTargetRef().toString()) > 0;
    }

    @Deprecated
    protected void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public void setIdentityCheck(boolean identityCheck) {
        this.identityCheck = identityCheck;
    }

    public void setLoggableTemplate(String loggableTemplateRef) {
        this.loggableTemplate = loggableTemplateRef != null ? new Template(loggableTemplateRef) : null;
    }

    public void setLoggableTemplate(Template loggableTemplate) {
        this.loggableTemplate = loggableTemplate;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    public void setLogPropertiesRef(Reference logPropertiesRef) {
        this.logPropertiesRef = logPropertiesRef;
    }

    public void setLogPropertiesRef(String logPropertiesUri) {
        this.setLogPropertiesRef(new Reference(logPropertiesUri));
    }

    public void setResponseLogFormat(String responseLogFormat) {
        this.responseLogFormat = responseLogFormat;
    }

    @Override
    public synchronized void start() throws Exception {
        Representation logProperties;
        super.start();
        Template template = this.responseLogTemplate = this.getResponseLogFormat() == null ? null : new Template(this.getResponseLogFormat());
        if (this.getLogPropertiesRef() != null && (logProperties = new ClientResource(this.getContext(), this.getLogPropertiesRef()).get()) != null) {
            LogManager.getLogManager().readConfiguration(logProperties.getStream());
        }
    }
}

