ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(v,w,z){"use strict";var $=v("./lib/dom"),L=v("./lib/oop"),_=v("./lib/event_emitter").EventEmitter,C=v("./lib/lang"),T=v("./range").Range,x=v("./range_list").RangeList,S=v("./keyboard/hash_handler").HashHandler,I=v("./tokenizer").Tokenizer,A=v("./clipboard"),k={CURRENT_WORD:function(t){return t.session.getTextRange(t.session.getWordRange())},SELECTION:function(t,e,o){var p=t.session.getTextRange();return o?p.replace(/\n\r?([ \t]*\S)/g,"\n"+o+"$1"):p},CURRENT_LINE:function(t){return t.session.getLine(t.getCursorPosition().row)},PREV_LINE:function(t){return t.session.getLine(t.getCursorPosition().row-1)},LINE_INDEX:function(t){return t.getCursorPosition().row},LINE_NUMBER:function(t){return t.getCursorPosition().row+1},SOFT_TABS:function(t){return t.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(t){return t.session.getTabSize()},CLIPBOARD:function(t){return A.getText&&A.getText()},FILENAME:function(t){return/[^/\\]*$/.exec(this.FILEPATH(t))[0]},FILENAME_BASE:function(t){return/[^/\\]*$/.exec(this.FILEPATH(t))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(t){return this.FILEPATH(t).replace(/[^/\\]*$/,"")},FILEPATH:function(t){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(t){var e=t.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(t){var e=t.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(t){return(t.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:y.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:y.bind(null,{year:"2-digit"}),CURRENT_MONTH:y.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:y.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:y.bind(null,{month:"short"}),CURRENT_DATE:y.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:y.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:y.bind(null,{weekday:"short"}),CURRENT_HOUR:y.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:y.bind(null,{minute:"2-digit"}),CURRENT_SECOND:y.bind(null,{second:"2-digit"})};function y(t){var e=(new Date).toLocaleString("en-us",t);return 1==e.length?"0"+e:e}k.SELECTED_TEXT=k.SELECTION;var E=function(){this.snippetMap={},this.snippetNameMap={}};(function(){L.implement(this,_),this.getTokenizer=function(){return E.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(n){return n=n.substr(1),/^\d+$/.test(n)?[{tabstopId:parseInt(n,10)}]:[{text:n}]}function o(n){return"(?:[^\\\\"+n+"]|\\\\.)"}var p={regex:"/("+o("/")+"+)/",onMatch:function(n,s,i){var r=i[0];return r.fmtString=!0,r.guard=n.slice(1,-1),r.flag="",""},next:"formatString"};return E.$tokenizer=new I({start:[{regex:/\\./,onMatch:function(n,s,i){var r=n[1];return("}"==r&&i.length||-1!="`$\\".indexOf(r))&&(n=r),[n]}},{regex:/}/,onMatch:function(n,s,i){return[i.length?i.shift():n]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(n,s,i){var r=e(n.substr(1));return i.unshift(r[0]),r},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+o("\\|")+"*\\|",onMatch:function(n,s,i){var r=n.slice(1,-1).replace(/\\[,|\\]|,/g,function(a){return 2==a.length?a[1]:"\0"}).split("\0").map(function(a){return{value:a}});return i[0].choices=r,[r[0]]},next:"start"},p,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(n,s,i){return i.length&&i[0].expectElse?(i[0].expectElse=!1,i[0].ifEnd={elseEnd:i[0]},[i[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(n,s,i){var r=n[1];return"}"==r&&i.length||-1!="`$\\".indexOf(r)?n=r:"n"==r?n="\n":"t"==r?n="\t":-1!="ulULE".indexOf(r)&&(n={changeCase:r,local:r>"a"}),[n]}},{regex:"/\\w*}",onMatch:function(n,s,i){var r=i.shift();return r&&(r.flag=n.slice(1,-1)),this.next=r&&r.tabstopId?"start":"",[r||n]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(n,s,i){return[{text:n.slice(1)}]}},{regex:/\${\w+/,onMatch:function(n,s,i){var r={text:n.slice(2)};return i.unshift(r),[r]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(n,s,i){var r=i.shift();return this.next=r&&r.tabstopId?"start":"",[r||n]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(n,s,i){return i[0].formatFunction=n.slice(2,-1),[i.shift()]},next:"formatString"},p,{regex:/:[\?\-+]?/,onMatch:function(n,s,i){"+"==n[1]&&(i[0].ifEnd=i[0]),"?"==n[1]&&(i[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,o){return this.getTokenizer().getLineTokens(e,o).tokens.map(function(p){return p.value||p})},this.getVariableValue=function(e,o,p){if(/^\d+$/.test(o))return(this.variables.__||{})[o]||"";if(/^[A-Z]\d+$/.test(o))return(this.variables[o[0]+"__"]||{})[o.substr(1)]||"";if(o=o.replace(/^TM_/,""),!this.variables.hasOwnProperty(o))return"";var n=this.variables[o];return"function"==typeof n&&(n=this.variables[o](e,o,p)),null==n?"":n},this.variables=k,this.tmStrFormat=function(e,o,p){if(!o.fmt)return e;var s=o.guard;s=new RegExp(s,(o.flag||"").replace(/[^gim]/g,""));var i="string"==typeof o.fmt?this.tokenizeTmSnippet(o.fmt,"formatString"):o.fmt,r=this,a=e.replace(s,function(){var l=r.variables.__;r.variables.__=[].slice.call(arguments);for(var d=r.resolveVariables(i,p),b="E",g=0;g<d.length;g++){var m=d[g];if("object"==typeof m)if(d[g]="",m.changeCase&&m.local){var R=d[g+1];R&&"string"==typeof R&&(d[g]="u"==m.changeCase?R[0].toUpperCase():R[0].toLowerCase(),d[g+1]=R.substr(1))}else m.changeCase&&(b=m.changeCase);else"U"==b?d[g]=m.toUpperCase():"L"==b&&(d[g]=m.toLowerCase())}return r.variables.__=l,d.join("")});return a},this.tmFormatFunction=function(e,o,p){return"upcase"==o.formatFunction?e.toUpperCase():"downcase"==o.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,o){for(var p=[],n="",s=!0,i=0;i<e.length;i++){var r=e[i];if("string"!=typeof r){if(r){if(s=!1,r.fmtString){var a=e.indexOf(r,i+1);-1==a&&(a=e.length),r.fmt=e.slice(i+1,a),i=a}if(r.text){var l=this.getVariableValue(o,r.text,n)+"";r.fmtString&&(l=this.tmStrFormat(l,r,o)),r.formatFunction&&(l=this.tmFormatFunction(l,r,o)),l&&!r.ifEnd?(p.push(l),d(r)):!l&&r.ifEnd&&d(r.ifEnd)}else r.elseEnd?d(r.elseEnd):(null!=r.tabstopId||null!=r.changeCase)&&p.push(r)}}else p.push(r),"\n"==r?(s=!0,n=""):s&&(n=/^\t*/.exec(r)[0],s=/\S/.test(r))}function d(b){var g=e.indexOf(b,i+1);-1!=g&&(i=g)}return p};var t=function(e,o,p){var n=e.getCursorPosition(),s=e.session.getLine(n.row),i=e.session.getTabString(),r=s.match(/^\s*/)[0];n.column<r.length&&(r=r.slice(0,n.column)),o=o.replace(/\r/g,"");var a=this.tokenizeTmSnippet(o);a=(a=this.resolveVariables(a,e)).map(function(M){return"\n"==M?M+r:"string"==typeof M?M.replace(/\t/g,i):M});var l=[];a.forEach(function(M,F){if("object"==typeof M){var D=M.tabstopId,P=l[D];if(P||((P=l[D]=[]).index=D,P.value="",P.parents={}),-1===P.indexOf(M)){M.choices&&!P.choices&&(P.choices=M.choices),P.push(M);var U=a.indexOf(M,F+1);if(-1!==U){var W=a.slice(F+1,U);W.some(function(G){return"object"==typeof G})&&!P.value?P.value=W:W.length&&(!P.value||"string"!=typeof P.value)&&(P.value=W.join(""))}}}}),l.forEach(function(M){M.length=0});var d={};function b(M){for(var F=[],D=0;D<M.length;D++){var P=M[D];if("object"==typeof P){if(d[P.tabstopId])continue;P=F[M.lastIndexOf(P,D-1)]||{tabstopId:P.tabstopId}}F[D]=P}return F}for(var g=0;g<a.length;g++){var m=a[g];if("object"==typeof m){var R=m.tabstopId,N=l[R],O=a.indexOf(m,g+1);if(d[R]){d[R]===m&&(delete d[R],Object.keys(d).forEach(function(M){N.parents[M]=!0}));continue}d[R]=m;var H=N.value;"string"!=typeof H?H=b(H):m.fmt&&(H=this.tmStrFormat(H,m,e)),a.splice.apply(a,[g+1,Math.max(0,O-g)].concat(H,m)),-1===N.indexOf(m)&&N.push(m)}}var V=0,B=0,K="";return a.forEach(function(M){if("string"==typeof M){var F=M.split("\n");F.length>1?(B=F[F.length-1].length,V+=F.length-1):B+=M.length,K+=M}else M&&(M.start?M.end={row:V,column:B}:M.start={row:V,column:B})}),{text:K,tabstops:l,tokens:a}};this.getDisplayTextForSnippet=function(e,o){return t.call(this,e,o).text},this.insertSnippetForSelection=function(e,o,p){var n=t.call(this,e,o),s=e.getSelectionRange();p&&0===p.compareRange(s)&&(s=p);var i=e.session.replace(s,n.text);new u(e).addTabstops(n.tabstops,s.start,i,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,o,p){var n=this;if(e.inVirtualSelectionMode)return n.insertSnippetForSelection(e,o,p);e.forEachSelection(function(){n.insertSnippetForSelection(e,o,p)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var o=e.session.$mode.$id||"";if("html"===(o=o.split("/").pop())||"php"===o){"php"===o&&!e.session.$mode.inlinePhp&&(o="html");var p=e.getCursorPosition(),n=e.session.getState(p.row);"object"==typeof n&&(n=n[0]),n.substring&&("js-"==n.substring(0,3)?o="javascript":"css-"==n.substring(0,4)?o="css":"php-"==n.substring(0,4)&&(o="php"))}return o},this.getActiveScopes=function(e){var o=this.$getScope(e),p=[o],n=this.snippetMap;return n[o]&&n[o].includeScopes&&p.push.apply(p,n[o].includeScopes),p.push("_"),p},this.expandWithTab=function(e,o){var p=this,n=e.forEachSelection(function(){return p.expandSnippetForSelection(e,o)},null,{keepOrder:!0});return n&&e.tabstopManager&&e.tabstopManager.tabNext(),n},this.expandSnippetForSelection=function(e,o){var a,p=e.getCursorPosition(),n=e.session.getLine(p.row),s=n.substring(0,p.column),i=n.substr(p.column),r=this.snippetMap;return this.getActiveScopes(e).some(function(l){var d=r[l];return d&&(a=this.findMatchingSnippet(d,s,i)),!!a},this),!!a&&(o&&o.dryRun||(e.session.doc.removeInLine(p.row,p.column-a.replaceBefore.length,p.column+a.replaceAfter.length),this.variables.M__=a.matchBefore,this.variables.T__=a.matchAfter,this.insertSnippetForSelection(e,a.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,o,p){for(var n=e.length;n--;){var s=e[n];if((!s.startRe||s.startRe.test(o))&&(!s.endRe||s.endRe.test(p))&&(s.startRe||s.endRe))return s.matchBefore=s.startRe?s.startRe.exec(o):[""],s.matchAfter=s.endRe?s.endRe.exec(p):[""],s.replaceBefore=s.triggerRe?s.triggerRe.exec(o)[0]:"",s.replaceAfter=s.endTriggerRe?s.endTriggerRe.exec(p)[0]:"",s}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,o){var p=this.snippetMap,n=this.snippetNameMap,s=this;function i(l){return l&&!/^\^?\(.*\)\$?$|^\\b$/.test(l)&&(l="(?:"+l+")"),l||""}function r(l,d,b){return l=i(l),d=i(d),b?(l=d+l)&&"$"!=l[l.length-1]&&(l+="$"):(l+=d)&&"^"!=l[0]&&(l="^"+l),new RegExp(l)}function a(l){l.scope||(l.scope=o||"_"),p[o=l.scope]||(p[o]=[],n[o]={});var d=n[o];if(l.name){var b=d[l.name];b&&s.unregister(b),d[l.name]=l}p[o].push(l),l.prefix&&(l.tabTrigger=l.prefix),!l.content&&l.body&&(l.content=Array.isArray(l.body)?l.body.join("\n"):l.body),l.tabTrigger&&!l.trigger&&(!l.guard&&/^\w/.test(l.tabTrigger)&&(l.guard="\\b"),l.trigger=C.escapeRegExp(l.tabTrigger)),(l.trigger||l.guard||l.endTrigger||l.endGuard)&&(l.startRe=r(l.trigger,l.guard,!0),l.triggerRe=new RegExp(l.trigger),l.endRe=r(l.endTrigger,l.endGuard,!0),l.endTriggerRe=new RegExp(l.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(a):Object.keys(e).forEach(function(l){a(e[l])}),this._signal("registerSnippets",{scope:o})},this.unregister=function(e,o){var p=this.snippetMap,n=this.snippetNameMap;function s(i){var r=n[i.scope||o];if(r&&r[i.name]){delete r[i.name];var a=p[i.scope||o],l=a&&a.indexOf(i);l>=0&&a.splice(l,1)}}e.content?s(e):Array.isArray(e)&&e.forEach(s)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var s,o=[],p={},n=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;s=n.exec(e);){if(s[1])try{p=JSON.parse(s[1]),o.push(p)}catch(l){}if(s[4])p.content=s[4].replace(/^\t/gm,""),o.push(p),p={};else{var i=s[2],r=s[3];if("regex"==i){var a=/\/((?:[^\/\\]|\\.)*)|$/g;p.guard=a.exec(r)[1],p.trigger=a.exec(r)[1],p.endTrigger=a.exec(r)[1],p.endGuard=a.exec(r)[1]}else"snippet"==i?(p.tabTrigger=r.match(/^\S*/)[0],p.name||(p.name=r)):i&&(p[i]=r)}}return o},this.getSnippetByName=function(e,o){var n,p=this.snippetNameMap;return this.getActiveScopes(o).some(function(s){var i=p[s];return i&&(n=i[e]),!!n},this),n}}).call(E.prototype);var u=function(t){if(t.tabstopManager)return t.tabstopManager;t.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=C.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(t)};(function(){this.attach=function(t){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=t,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(t){for(var e="r"==t.action[0],o=this.selectedTabstop||{},p=o.parents||{},n=(this.tabstops||[]).slice(),s=0;s<n.length;s++){var i=n[s];if(i.rangeList.$bias=i==o||p[i.index]?0:1,"remove"==t.action&&i!==o){var a=i.parents&&i.parents[o.index],l=i.rangeList.pointIndex(t.start,a);l=l<0?-l-1:l+1;for(var d=i.rangeList.pointIndex(t.end,a),b=i.rangeList.ranges.slice(l,d=d<0?-d-1:d-1),g=0;g<b.length;g++)this.removeRange(b[g])}i.rangeList.$onChange(t)}var m=this.editor.session;!this.$inChange&&e&&1==m.getLength()&&!m.getValue()&&this.detach()},this.updateLinkedFields=function(){var t=this.selectedTabstop;if(t&&t.hasLinkedRanges&&t.firstNonLinked){this.$inChange=!0;for(var e=this.editor.session,o=e.getTextRange(t.firstNonLinked),p=0;p<t.length;p++){var n=t[p];if(n.linked){var i=w.snippetManager.tmStrFormat(o,n.original,this.editor);e.replace(n,i)}}this.$inChange=!1}},this.onAfterExec=function(t){t.command&&!t.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var t=this.editor.selection.lead,e=this.editor.selection.anchor,o=this.editor.selection.isEmpty(),p=0;p<this.ranges.length;p++)if(!this.ranges[p].linked){var n=this.ranges[p].contains(t.row,t.column),s=o||this.ranges[p].contains(e.row,e.column);if(n&&s)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(t){var e=this.tabstops.length,o=this.index+(t||1);(o=Math.min(Math.max(o,1),e))==e&&(o=0),this.selectTabstop(o),0===o&&this.detach()},this.selectTabstop=function(t){this.$openTabstops=null;var e=this.tabstops[this.index];if(e&&this.addTabstopMarkers(e),this.index=t,(e=this.tabstops[this.index])&&e.length){this.selectedTabstop=e;var o=e.firstNonLinked||e;if(e.choices&&(o.cursor=o.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(o);else{var p=this.editor.multiSelect;p.toSingleRange(o);for(var n=0;n<e.length;n++)e.hasLinkedRanges&&e[n].linked||p.addRange(e[n].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(t,e,o){var p=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!t[0]){var n=T.fromPoints(o,o);c(n.start,e),c(n.end,e),t[0]=[n],t[0].index=0}var i=[this.index+1,0],r=this.ranges;t.forEach(function(a,l){for(var d=this.$openTabstops[l]||a,b=0;b<a.length;b++){var g=a[b],m=T.fromPoints(g.start,g.end||g.start);f(m.start,e),f(m.end,e),m.original=g,m.tabstop=d,r.push(m),d!=a?d.unshift(m):d[b]=m,g.fmtString||d.firstNonLinked&&p?(m.linked=!0,d.hasLinkedRanges=!0):d.firstNonLinked||(d.firstNonLinked=m)}d.firstNonLinked||(d.hasLinkedRanges=!1),d===a&&(i.push(d),this.$openTabstops[l]=d),this.addTabstopMarkers(d),d.rangeList=d.rangeList||new x,d.rangeList.$bias=0,d.rangeList.addList(d)},this),i.length>2&&(this.tabstops.length&&i.push(i.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,i))},this.addTabstopMarkers=function(t){var e=this.editor.session;t.forEach(function(o){o.markerId||(o.markerId=e.addMarker(o,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(t){var e=this.editor.session;t.forEach(function(o){e.removeMarker(o.markerId),o.markerId=null})},this.removeRange=function(t){var e=t.tabstop.indexOf(t);-1!=e&&t.tabstop.splice(e,1),-1!=(e=this.ranges.indexOf(t))&&this.ranges.splice(e,1),-1!=(e=t.tabstop.rangeList.ranges.indexOf(t))&&t.tabstop.splice(e,1),this.editor.session.removeMarker(t.markerId),t.tabstop.length||(-1!=(e=this.tabstops.indexOf(t.tabstop))&&this.tabstops.splice(e,1),this.tabstops.length||this.detach())},this.keyboardHandler=new S,this.keyboardHandler.bindKeys({Tab:function(t){w.snippetManager&&w.snippetManager.expandWithTab(t)||(t.tabstopManager.tabNext(1),t.renderer.scrollCursorIntoView())},"Shift-Tab":function(t){t.tabstopManager.tabNext(-1),t.renderer.scrollCursorIntoView()},Esc:function(t){t.tabstopManager.detach()}})}).call(u.prototype);var f=function(t,e){0==t.row&&(t.column+=e.column),t.row+=e.row},c=function(t,e){t.row==e.row&&(t.column-=e.column),t.row-=e.row};$.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),w.snippetManager=new E;var h=v("./editor").Editor;(function(){this.insertSnippet=function(t,e){return w.snippetManager.insertSnippet(this,t,e)},this.expandSnippet=function(t){return w.snippetManager.expandWithTab(this,t)}}).call(h.prototype)}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets"],function(v,w,z){"use strict";var $=v("../snippets").snippetManager,L=function(){function _(){this.editor=null}return _.prototype.show=function(C,T,x){if(x=x||"",C&&this.editor&&this.editor!==C&&(this.hide(),this.editor=null),!C||!T)return!1;var S=T.snippet?$.getDisplayTextForSnippet(C,T.snippet):T.value;return!(!S||!S.startsWith(x)||(this.editor=C,""===(S=S.slice(x.length))?C.removeGhostText():C.setGhostText(S),0))},_.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},_.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},_.prototype.destroy=function(){this.hide(),this.editor=null},_}();w.AceInline=L}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom"],function(v,w,z){"use strict";var $=v("../virtual_renderer").VirtualRenderer,L=v("../editor").Editor,_=v("../range").Range,C=v("../lib/event"),T=v("../lib/lang"),x=v("../lib/dom"),S=function(k){return"suggest-aria-id:".concat(k)},I=function(k){var y=new $(k);y.$maxLines=4;var E=new L(y);return E.setHighlightActiveLine(!1),E.setShowPrintMargin(!1),E.renderer.setShowGutter(!1),E.renderer.setHighlightGutterLine(!1),E.$mouseHandler.$focusTimeout=0,E.$highlightTagPending=!0,E};x.importCssString("\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin: 0 0.9em;\n}\n.ace_completion-message {\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete_right .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete_right .ace_line {\n    display: flex;\n}\n.ace_autocomplete_right .ace_completion-meta {\n    flex: 1;\n    text-align: right;\n}\n","autocompletion.css",!1),w.AcePopup=function k(y){var E=x.createElement("div"),u=new I(E);y&&y.appendChild(E),E.style.display="none",u.renderer.content.style.cursor="default",u.renderer.setStyle("ace_autocomplete"),u.renderer.container.setAttribute("role","listbox"),u.renderer.container.setAttribute("aria-label","Autocomplete suggestions"),u.setOption("displayIndentGuides",!1),u.setOption("dragDelay",150);var f=function(){};u.focus=f,u.$isFocused=!0,u.renderer.$cursorLayer.restartTimer=f,u.renderer.$cursorLayer.element.style.opacity=0,u.renderer.$maxLines=8,u.renderer.$keepTextAreaAtCursor=!1,u.setHighlightActiveLine(!1),u.session.highlight(""),u.session.$searchHighlight.clazz="ace_highlight-marker",u.on("mousedown",function(n){var s=n.getDocumentPosition();u.selection.moveToPosition(s),t.start.row=t.end.row=s.row,n.stop()});var c,h=new _(-1,0,-1,1/0),t=new _(-1,0,-1,1/0);t.id=u.session.addMarker(t,"ace_active-line","fullLine"),u.setSelectOnHover=function(n){n?h.id&&(u.session.removeMarker(h.id),h.id=null):h.id=u.session.addMarker(h,"ace_line-hover","fullLine")},u.setSelectOnHover(!1),u.on("mousemove",function(n){if(c){if(c.x!=n.x||c.y!=n.y){(c=n).scrollTop=u.renderer.scrollTop;var s=c.getDocumentPosition().row;h.start.row!=s&&(h.id||u.setRow(s),o(s))}}else c=n}),u.renderer.on("beforeRender",function(){if(c&&-1!=h.start.row){c.$pos=null;var n=c.getDocumentPosition().row;h.id||u.setRow(n),o(n,!0)}}),u.renderer.on("afterRender",function(){var n=u.getRow(),s=u.renderer.$textLayer,i=s.element.childNodes[n-s.config.firstRow],r=document.activeElement;if(i!==s.selectedNode&&s.selectedNode&&(x.removeCssClass(s.selectedNode,"ace_selected"),r.removeAttribute("aria-activedescendant"),s.selectedNode.removeAttribute("id")),s.selectedNode=i,i){x.addCssClass(i,"ace_selected");var a=S(n);i.id=a,u.renderer.container.setAttribute("aria-activedescendant",a),r.setAttribute("aria-activedescendant",a),i.setAttribute("role","option"),i.setAttribute("aria-label",u.getData(n).value),i.setAttribute("aria-setsize",u.data.length),i.setAttribute("aria-posinset",n)}});var e=function(){o(-1)},o=function(n,s){n!==h.start.row&&(h.start.row=h.end.row=n,s||u.session._emit("changeBackMarker"),u._emit("changeHoverMarker"))};u.getHoveredRow=function(){return h.start.row},C.addListener(u.container,"mouseout",e),u.on("hide",e),u.on("changeSelection",e),u.session.doc.getLength=function(){return u.data.length},u.session.doc.getLine=function(n){var s=u.data[n];return"string"==typeof s?s:s&&s.value||""};var p=u.session.bgTokenizer;return p.$tokenizeRow=function(n){var s=u.data[n],i=[];if(!s)return i;"string"==typeof s&&(s={value:s});var r=s.caption||s.value||s.name;function a(O,H){O&&i.push({type:(s.className||"")+(H||""),value:O})}for(var l=r.toLowerCase(),d=(u.filterText||"").toLowerCase(),b=0,g=0,m=0;m<=d.length;m++)if(m!=g&&(s.matchMask&1<<m||m==d.length)){var R=d.slice(g,m);g=m;var N=l.indexOf(R,b);if(-1==N)continue;a(r.slice(b,N),""),a(r.slice(N,b=N+R.length),"completion-highlight")}return a(r.slice(b,r.length),""),s.meta&&i.push({type:"completion-meta",value:s.meta}),s.message&&i.push({type:"completion-message",value:s.message}),i},p.$updateOnChange=f,p.start=f,u.session.$computeWidth=function(){return this.screenWidth=0},u.isOpen=!1,u.isTopdown=!1,u.autoSelect=!0,u.filterText="",u.data=[],u.setData=function(n,s){u.filterText=s||"",u.setValue(T.stringRepeat("\n",n.length),-1),u.data=n||[],u.setRow(0)},u.getData=function(n){return u.data[n]},u.getRow=function(){return t.start.row},u.setRow=function(n){n=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,n)),t.start.row!=n&&(u.selection.clearSelection(),t.start.row=t.end.row=n||0,u.session._emit("changeBackMarker"),u.moveCursorTo(n||0,0),u.isOpen&&u._signal("select"))},u.on("changeSelection",function(){u.isOpen&&u.setRow(u.selection.lead.row),u.renderer.scrollCursorIntoView()}),u.hide=function(){this.container.style.display="none",u.anchorPos=null,u.anchor=null,u.isOpen&&(u.isOpen=!1,this._signal("hide"))},u.tryShow=function(n,s,i,r){if(!r&&u.isOpen&&u.anchorPos&&u.anchor&&u.anchorPos.top===n.top&&u.anchorPos.left===n.left&&u.anchor===i)return!0;var a=this.container,l=window.innerHeight,d=window.innerWidth,b=this.renderer,g=b.$maxLines*s*1.4,m={top:0,bottom:0,left:0},R=l-n.top-3*this.$borderSize-s,N=n.top-3*this.$borderSize;i||(i=N<=R||R>=g?"bottom":"top"),"top"===i?(m.bottom=n.top-this.$borderSize,m.top=m.bottom-g):"bottom"===i&&(m.top=n.top+s+this.$borderSize,m.bottom=m.top+g);var O=m.top>=0&&m.bottom<=l;if(!r&&!O)return!1;b.$maxPixelHeight=O?null:"top"===i?N:R,"top"===i?(a.style.top="",a.style.bottom=l-m.bottom+"px",u.isTopdown=!1):(a.style.top=m.top+"px",a.style.bottom="",u.isTopdown=!0),a.style.display="";var H=n.left;return H+a.offsetWidth>d&&(H=d-a.offsetWidth),a.style.left=H+"px",a.style.right="",u.isOpen||(u.isOpen=!0,this._signal("show"),c=null),u.anchorPos=n,u.anchor=i,!0},u.show=function(n,s,i){this.tryShow(n,s,i?"bottom":void 0,!0)},u.goTo=function(n){var s=this.getRow(),i=this.session.getLength()-1;switch(n){case"up":s=s<=0?i:s-1;break;case"down":s=s>=i?-1:s+1;break;case"start":s=0;break;case"end":s=i}this.setRow(s)},u.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},u.$imageSize=0,u.$borderSize=1,u},w.$singleLineEditor=I,w.getAriaId=S}),ace.define("ace/autocomplete/util",["require","exports","module"],function(v,w,z){"use strict";w.parForEach=function(L,_,C){var T=0,x=L.length;0===x&&C();for(var S=0;S<x;S++)_(L[S],function(I,A){++T===x&&C(I,A)})};var $=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;w.retrievePrecedingIdentifier=function(L,_,C){C=C||$;for(var T=[],x=_-1;x>=0&&C.test(L[x]);x--)T.push(L[x]);return T.reverse().join("")},w.retrieveFollowingIdentifier=function(L,_,C){C=C||$;for(var T=[],x=_;x<L.length&&C.test(L[x]);x++)T.push(L[x]);return T},w.getCompletionPrefix=function(L){var T,_=L.getCursorPosition(),C=L.session.getLine(_.row);return L.completers.forEach(function(x){x.identifierRegexps&&x.identifierRegexps.forEach(function(S){!T&&S&&(T=this.retrievePrecedingIdentifier(C,_.column,S))}.bind(this))}.bind(this)),T||this.retrievePrecedingIdentifier(C,_.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(v,w,z){"use strict";var $=v("./keyboard/hash_handler").HashHandler,L=v("./autocomplete/popup").AcePopup,_=v("./autocomplete/inline").AceInline,C=v("./autocomplete/popup").getAriaId,T=v("./autocomplete/util"),x=v("./lib/lang"),S=v("./lib/dom"),I=v("./snippets").snippetManager,A=v("./config"),k=function(f,c){c.completer&&c.completer.destroy()},y=function(){function f(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new $,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=x.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=x.delayedCall(this.updateDocTooltip.bind(this),50)}return f.prototype.$init=function(){return this.popup=new L(document.body||document.documentElement),this.popup.on("click",function(c){this.insertMatch(),c.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupChange.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},f.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new _,this.inlineRenderer},f.prototype.getPopup=function(){return this.popup||this.$init()},f.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip()},f.prototype.$onPopupChange=function(c){if(this.inlineRenderer&&this.inlineEnabled){var h=c?null:this.popup.getData(this.popup.getRow()),t=T.getCompletionPrefix(this.editor);this.inlineRenderer.show(this.editor,h,t)||this.inlineRenderer.hide(),this.$updatePopupPosition()}this.tooltipTimer.call(null,null)},f.prototype.$updatePopupPosition=function(){var c=this.editor,h=c.renderer,t=h.layerConfig.lineHeight,e=h.$cursorLayer.getPixelPosition(this.base,!0);e.left-=this.popup.getTextLeftOffset();var o=c.container.getBoundingClientRect();e.top+=o.top-h.layerConfig.offset,e.left+=o.left-c.renderer.scrollLeft,e.left+=h.gutterWidth;var p={top:e.top,left:e.left};h.$ghostText&&h.$ghostTextWidget&&this.base.row===h.$ghostText.position.row&&(p.top+=h.$ghostTextWidget.el.offsetHeight),!this.popup.tryShow(p,t,"bottom")&&(this.popup.tryShow(e,t,"top")||this.popup.show(e,t))},f.prototype.openPopup=function(c,h,t){this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:C(this.popup.getRow()),inline:this.inlineEnabled}),c.keyBinding.addKeyboardHandler(this.keyboardHandler),this.popup.setRow(this.autoSelect?0:-1),t?t&&!h&&this.detach():(this.popup.setTheme(c.getTheme()),this.popup.setFontSize(c.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel()},f.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},f.prototype.changeListener=function(c){var h=this.editor.selection.lead;(h.row!=this.base.row||h.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},f.prototype.blurListener=function(c){var h=document.activeElement,t=this.editor.textInput.getElement(),e=c.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(c.relatedTarget);h!=t&&h.parentNode!=(this.popup&&this.popup.container)&&!e&&h!=this.tooltipNode&&c.relatedTarget!=t&&this.detach()},f.prototype.mousedownListener=function(c){this.detach()},f.prototype.mousewheelListener=function(c){this.detach()},f.prototype.goTo=function(c){this.popup.goTo(c)},f.prototype.insertMatch=function(c,h){if(c||(c=this.popup.getData(this.popup.getRow())),!c)return!1;var t=this.completions,e=this.getCompletionProvider().insertMatch(this.editor,c,t.filterText,h);return this.completions==t&&this.detach(),e},f.prototype.showPopup=function(c,h){this.editor&&this.detach(),this.activated=!0,this.editor=c,c.completer!=this&&(c.completer&&c.completer.detach(),c.completer=this),c.on("changeSelection",this.changeListener),c.on("blur",this.blurListener),c.on("mousedown",this.mousedownListener),c.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,h)},f.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new E),this.completionProvider},f.prototype.gatherCompletions=function(c,h){return this.getCompletionProvider().gatherCompletions(c,h)},f.prototype.updateCompletions=function(c,h){if(c&&this.base&&this.completions){var e=this.editor.getCursorPosition();if((o=this.editor.session.getTextRange({start:this.base,end:e}))==this.completions.filterText)return;return this.completions.setFilter(o),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=o||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,o,c):this.detach()}if(h&&h.matches)return e=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(e.row,e.column),this.base.$insertRight=!0,this.completions=new u(h.matches),this.openPopup(this.editor,"",c);var t=this.editor.getSession(),o=(e=this.editor.getCursorPosition(),T.getCompletionPrefix(this.editor));this.base=t.doc.createAnchor(e.row,e.column-o.length),this.base.$insertRight=!0;var p={exactMatch:this.exactMatch};this.getCompletionProvider().provideCompletions(this.editor,p,function(n,s,i){var r=s.filtered,a=T.getCompletionPrefix(this.editor);if(i){if(!r.length)return this.detach();if(1==r.length&&r[0].value==a&&!r[0].snippet)return this.detach();if(this.autoInsert&&1==r.length)return this.insertMatch(r[0])}this.completions=s,this.openPopup(this.editor,a,c)}.bind(this))},f.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},f.prototype.updateDocTooltip=function(){var c=this.popup,h=c.data,t=h&&(h[c.getHoveredRow()]||h[c.getRow()]),e=null;if(!t||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var o=this.editor.completers.length,p=0;p<o;p++){var n=this.editor.completers[p];if(n.getDocTooltip&&t.completerId===n.id){e=n.getDocTooltip(t);break}}if(!e&&"string"!=typeof t&&(e=t),"string"==typeof e&&(e={docText:e}),!e||!e.docHTML&&!e.docText)return this.hideDocTooltip();this.showDocTooltip(e)},f.prototype.showDocTooltip=function(c){this.tooltipNode||(this.tooltipNode=S.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var h=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(h.isDark?"ace_dark ":"")+(h.cssClass||"");var t=this.tooltipNode;c.docHTML?t.innerHTML=c.docHTML:c.docText&&(t.textContent=c.docText),t.parentNode||document.body.appendChild(t);var e=this.popup,o=e.container.getBoundingClientRect();t.style.top=e.container.style.top,t.style.bottom=e.container.style.bottom,t.style.display="block",window.innerWidth-o.right<320?o.left<320?e.isTopdown?(t.style.top=o.bottom+"px",t.style.left=o.left+"px",t.style.right="",t.style.bottom=""):(t.style.top=e.container.offsetTop-t.offsetHeight+"px",t.style.left=o.left+"px",t.style.right="",t.style.bottom=""):(t.style.right=window.innerWidth-o.left+"px",t.style.left=""):(t.style.left=o.right+1+"px",t.style.right="")},f.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var c=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==c&&this.editor.focus(),this.tooltipNode=null,c.parentNode&&c.parentNode.removeChild(c)}},f.prototype.onTooltipClick=function(c){for(var h=c.target;h&&h!=this.tooltipNode;){if("A"==h.nodeName&&h.href){h.rel="noreferrer",h.target="_blank";break}h=h.parentNode}},f.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var c=this.popup.container;c&&c.parentNode&&c.parentNode.removeChild(c)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",k),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},f}();y.prototype.commands={Up:function(f){f.completer.goTo("up")},Down:function(f){f.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(f){f.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(f){f.completer.goTo("end")},Esc:function(f){f.completer.detach()},Return:function(f){return f.completer.insertMatch()},"Shift-Return":function(f){f.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(f){var c=f.completer.insertMatch();if(c||f.tabstopManager)return c;f.completer.goTo("down")},PageUp:function(f){f.completer.popup.gotoPageUp()},PageDown:function(f){f.completer.popup.gotoPageDown()}},y.for=function(f){return f.completer instanceof y||(f.completer&&(f.completer.destroy(),f.completer=null),A.get("sharedPopups")?(y.$sharedInstance||(y.$sharedInstance=new y),f.completer=y.$sharedInstance):(f.completer=new y,f.once("destroy",k))),f.completer},y.startCommand={name:"startAutocomplete",exec:function(f,c){var h=y.for(f);h.autoInsert=!1,h.autoSelect=!0,h.showPopup(f,c),h.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var E=function(){function f(){this.active=!0}return f.prototype.insertByIndex=function(c,h,t){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(c,this.completions.filtered[h],t)},f.prototype.insertMatch=function(c,h,t){if(!h)return!1;if(c.startOperation({command:{name:"insertMatch"}}),h.completer&&h.completer.insertMatch)h.completer.insertMatch(c,h);else{if(!this.completions)return!1;if(this.completions.filterText)for(var p,e=c.selection.getAllRanges(),o=0;p=e[o];o++)p.start.column-=this.completions.filterText.length,c.session.remove(p);h.snippet?I.insertSnippet(c,h.snippet,h.range):this.$insertString(c,h),h.command&&"startAutocomplete"===h.command&&c.execCommand(h.command)}return c.endOperation(),!0},f.prototype.$insertString=function(c,h){var t=h.value||h;if(h.range){if(c.inVirtualSelectionMode)return c.session.replace(h.range,t);c.forEachSelection(function(){var e=c.getSelectionRange();0===h.range.compareRange(e)?c.session.replace(h.range,t):c.insert(t)},null,{keepOrder:!0})}else c.execCommand("insertstring",t)},f.prototype.gatherCompletions=function(c,h){var t=c.getSession(),e=c.getCursorPosition(),o=T.getCompletionPrefix(c),p=[],n=c.completers.length;return c.completers.forEach(function(s,i){s.getCompletions(c,t,e,o,function(r,a){!r&&a&&(p=p.concat(a)),h(null,{prefix:T.getCompletionPrefix(c),matches:p,finished:0==--n})})}),!0},f.prototype.provideCompletions=function(c,h,t){var e=function(s){var i=s.prefix;this.completions=new u(s.matches),h.exactMatch&&(this.completions.exactMatch=!0),h.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(i),(s.finished||this.completions.filtered.length)&&t(null,this.completions,s.finished)}.bind(this),o=!0,p=null;if(this.gatherCompletions(c,function(s,i){if(this.active&&(s&&(t(s,[],!0),this.detach()),0===i.prefix.indexOf(i.prefix))){if(o)return void(p=i);e(i)}}.bind(this)),o=!1,p){var n=p;p=null,e(n)}},f.prototype.detach=function(){this.active=!1},f}(),u=function(){function f(c,h){this.all=c,this.filtered=c,this.filterText=h||"",this.exactMatch=!1,this.ignoreCaption=!1}return f.prototype.setFilter=function(c){if(c.length>this.filterText&&0===c.lastIndexOf(this.filterText,0))var h=this.filtered;else h=this.all;this.filterText=c,h=(h=this.filterCompletions(h,this.filterText)).sort(function(e,o){return o.exactMatch-e.exactMatch||o.$score-e.$score||(e.caption||e.value).localeCompare(o.caption||o.value)});var t=null;h=h.filter(function(e){var o=e.snippet||e.caption||e.value;return o!==t&&(t=o,!0)}),this.filtered=h},f.prototype.filterCompletions=function(c,h){var t=[],e=h.toUpperCase(),o=h.toLowerCase();e:for(var n,p=0;n=c[p];p++){var s=!this.ignoreCaption&&n.caption||n.value||n.snippet;if(s){var l,d,i=-1,r=0,a=0;if(this.exactMatch){if(h!==s.substr(0,h.length))continue e}else{var b=s.toLowerCase().indexOf(o);if(b>-1)a=b;else for(var g=0;g<h.length;g++){var m=s.indexOf(o[g],i+1),R=s.indexOf(e[g],i+1);if((l=m>=0&&(R<0||m<R)?m:R)<0)continue e;(d=l-i-1)>0&&(-1===i&&(a+=10),a+=d,r|=1<<g),i=l}}n.matchMask=r,n.exactMatch=a?0:1,n.$score=(n.score||0)-a,t.push(n)}}return t},f}();w.Autocomplete=y,w.CompletionProvider=E,w.FilteredList=u}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(v,w,z){var $=v("../range").Range,L=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;w.getCompletions=function(T,x,S,I,A){var k=function C(T,x){var S=function _(T,x){return T.getTextRange($.fromPoints({row:0,column:0},x)).split(L).length-1}(T,x),I=T.getValue().split(L),A=Object.create(null),k=I[S];return I.forEach(function(y,E){if(y&&y!==k){var u=Math.abs(S-E),f=I.length-u;A[y]=A[y]?Math.max(f,A[y]):f}}),A}(x,S);A(null,Object.keys(k).map(function(E){return{caption:E,value:E,score:k[E],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(v,w,z){"use strict";var $=v("../snippets").snippetManager,L=v("../autocomplete").Autocomplete,_=v("../config"),C=v("../lib/lang"),T=v("../autocomplete/util"),x=v("../autocomplete/text_completer"),S={getCompletions:function(t,e,o,p,n){if(e.$mode.completer)return e.$mode.completer.getCompletions(t,e,o,p,n);var s=t.session.getState(o.row),i=e.$mode.getCompletions(s,e,o,p);n(null,i=i.map(function(r){return r.completerId=S.id,r}))},id:"keywordCompleter"},I=function(t){var e={};return t.replace(/\${(\d+)(:(.*?))?}/g,function(o,p,n,s){return e[p]=s||""}).replace(/\$(\d+?)/g,function(o,p){return e[p]})},A={getCompletions:function(t,e,o,p,n){var s=[],i=e.getTokenAt(o.row,o.column);i&&i.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?s.push("html-tag"):s=$.getActiveScopes(t);var r=$.snippetMap,a=[];s.forEach(function(l){for(var d=r[l]||[],b=d.length;b--;){var g=d[b],m=g.name||g.tabTrigger;!m||a.push({caption:m,snippet:g.content,meta:g.tabTrigger&&!g.name?g.tabTrigger+"\u21e5 ":"snippet",completerId:A.id})}},this),n(null,a)},getDocTooltip:function(t){t.snippet&&!t.docHTML&&(t.docHTML=["<b>",C.escapeHTML(t.caption),"</b>","<hr></hr>",C.escapeHTML(I(t.snippet))].join(""))},id:"snippetCompleter"},k=[A,x,S];w.setCompleters=function(t){k.length=0,t&&k.push.apply(k,t)},w.addCompleter=function(t){k.push(t)},w.textCompleter=x,w.keyWordCompleter=S,w.snippetCompleter=A;var y={name:"expandSnippet",exec:function(t){return $.expandWithTab(t)},bindKey:"Tab"},E=function(t,e){u(e.session.$mode)},u=function(t){"string"==typeof t&&(t=_.$modes[t]),t&&($.files||($.files={}),f(t.$id,t.snippetFileId),t.modes&&t.modes.forEach(u))},f=function(t,e){!e||!t||$.files[t]||($.files[t]={},_.loadModule(e,function(o){!o||($.files[t]=o,!o.snippets&&o.snippetText&&(o.snippets=$.parseSnippetFile(o.snippetText)),$.register(o.snippets||[],o.scope),o.includeScopes&&($.snippetMap[o.scope].includeScopes=o.includeScopes,o.includeScopes.forEach(function(p){u("ace/mode/"+p)})))}))},c=function(t){var e=t.editor,o=e.completer&&e.completer.activated;if("backspace"===t.command.name)o&&!T.getCompletionPrefix(e)&&e.completer.detach();else if("insertstring"===t.command.name&&T.getCompletionPrefix(e)&&!o){var n=L.for(e);n.autoInsert=!1,n.showPopup(e)}},h=v("../editor").Editor;v("../config").defineOptions(h.prototype,"editor",{enableBasicAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:k),this.commands.addCommand(L.startCommand)):this.commands.removeCommand(L.startCommand)},value:!1},enableLiveAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:k),this.commands.on("afterExec",c)):this.commands.removeListener("afterExec",c)},value:!1},enableSnippets:{set:function(t){t?(this.commands.addCommand(y),this.on("changeMode",E),E(0,this)):(this.commands.removeCommand(y),this.off("changeMode",E))},value:!1}})}),ace.define("ace/ext/inline_autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/inline","ace/autocomplete","ace/autocomplete","ace/editor","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/lib/useragent","ace/ext/language_tools","ace/ext/language_tools","ace/ext/language_tools","ace/config"],function(v,w,z){"use strict";var $=v("../keyboard/hash_handler").HashHandler,L=v("../autocomplete/inline").AceInline,_=v("../autocomplete").FilteredList,C=v("../autocomplete").CompletionProvider,T=v("../editor").Editor,x=v("../autocomplete/util"),S=v("../lib/lang"),I=v("../lib/dom"),A=v("../lib/useragent"),k=v("./language_tools").snippetCompleter,y=v("./language_tools").textCompleter,E=v("./language_tools").keyWordCompleter,u=function(i,r){r.completer&&r.completer.destroy()},f=function(i,r){return r.row>i.row||r.row===i.row&&r.column>i.column?i:r},c=function(){function i(r){this.editor=r,this.tooltipEnabled=!0,this.keyboardHandler=new $(this.commands),this.$index=-1,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=S.delayedCall(function(){this.updateCompletions()}.bind(this))}return i.prototype.getInlineRenderer=function(){return this.inlineRenderer||(this.inlineRenderer=new L),this.inlineRenderer},i.prototype.getInlineTooltip=function(){return this.inlineTooltip||(this.inlineTooltip=new n(this.editor,document.body||document.documentElement),this.inlineTooltip.setCommands(this.commands)),this.inlineTooltip},i.prototype.show=function(r){this.activated=!0,this.editor.completer!==this&&(this.editor.completer&&this.editor.completer.detach(),this.editor.completer=this),this.editor.on("changeSelection",this.changeListener),this.editor.on("blur",this.blurListener),this.editor.on("mousewheel",this.mousewheelListener),this.updateCompletions(r)},i.prototype.$open=function(){this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({}),this.tooltipEnabled&&this.getInlineTooltip().show(this.editor),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),-1===this.$index?this.setIndex(0):this.$showCompletion(),this.changeTimer.cancel()},i.prototype.insertMatch=function(){var r=this.getCompletionProvider().insertByIndex(this.editor,this.$index);return this.detach(),r},i.prototype.changeListener=function(r){var a=this.editor.selection.lead;(a.row!=this.base.row||a.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},i.prototype.blurListener=function(r){this.detach()},i.prototype.mousewheelListener=function(r){this.inlineTooltip&&this.inlineTooltip.isShown()&&this.inlineTooltip.updatePosition()},i.prototype.goTo=function(r){if(this.completions&&this.completions.filtered)switch(r.toLowerCase()){case"prev":this.setIndex(Math.max(0,this.$index-1));break;case"next":this.setIndex(this.$index+1);break;case"first":this.setIndex(0);break;case"last":this.setIndex(this.completions.filtered.length-1)}},i.prototype.getLength=function(){return this.completions&&this.completions.filtered?this.completions.filtered.length:0},i.prototype.getData=function(r){return null==r||null===r?this.completions.filtered[this.$index]:this.completions.filtered[r]},i.prototype.getIndex=function(){return this.$index},i.prototype.isOpen=function(){return this.$index>=0},i.prototype.setIndex=function(r){if(this.completions&&this.completions.filtered){var a=Math.max(-1,Math.min(this.completions.filtered.length-1,r));a!==this.$index&&(this.$index=a,this.$showCompletion())}},i.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new C),this.completionProvider},i.prototype.$showCompletion=function(){this.getInlineRenderer().show(this.editor,this.completions.filtered[this.$index],this.completions.filterText)||this.getInlineRenderer().hide(),this.inlineTooltip&&this.inlineTooltip.isShown()&&this.inlineTooltip.updateButtons()},i.prototype.$updatePrefix=function(){var r=this.editor.getCursorPosition(),a=this.editor.session.getTextRange({start:this.base,end:r});return this.completions.setFilter(a),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=a||this.completions.filtered[0].snippet)?(this.$open(this.editor,a),a):this.detach()},i.prototype.updateCompletions=function(b){var d="";if(b&&b.matches){var l=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(l.row,l.column),this.base.$insertRight=!0,this.completions=new _(b.matches),this.$open(this.editor,"")}this.base&&this.completions&&(d=this.$updatePrefix());var a=this.editor.getSession();l=this.editor.getCursorPosition(),d=x.getCompletionPrefix(this.editor),this.base=a.doc.createAnchor(l.row,l.column-d.length),this.base.$insertRight=!0,b={exactMatch:!0,ignoreCaption:!0},this.getCompletionProvider().provideCompletions(this.editor,b,function(g,m,R){var N=m.filtered,O=x.getCompletionPrefix(this.editor);if(R){if(!N.length)return this.detach();if(1==N.length&&N[0].value==O&&!N[0].snippet)return this.detach()}this.completions=m,this.$open(this.editor,O)}.bind(this))},i.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousewheel",this.mousewheelListener)),this.changeTimer.cancel(),this.inlineTooltip&&this.inlineTooltip.detach(),this.setIndex(-1),this.completionProvider&&this.completionProvider.detach(),this.inlineRenderer&&this.inlineRenderer.isOpen()&&this.inlineRenderer.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},i.prototype.destroy=function(){this.detach(),this.inlineRenderer&&this.inlineRenderer.destroy(),this.inlineTooltip&&this.inlineTooltip.destroy(),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",u),this.editor.completer=null),this.inlineTooltip=this.editor=this.inlineRenderer=null},i}();c.prototype.commands={Previous:{bindKey:"Alt-[",name:"Previous",exec:function(i){i.completer.goTo("prev")},enabled:function(i){return i.completer.getIndex()>0},position:10},Next:{bindKey:"Alt-]",name:"Next",exec:function(i){i.completer.goTo("next")},enabled:function(i){return i.completer.getIndex()<i.completer.getLength()-1},position:20},Accept:{bindKey:{win:"Tab|Ctrl-Right",mac:"Tab|Cmd-Right"},name:"Accept",exec:function(i){return i.completer.insertMatch()},enabled:function(i){return i.completer.getIndex()>=0},position:30},Close:{bindKey:"Esc",name:"Close",exec:function(i){i.completer.detach()},enabled:!0,position:40}},c.for=function(i){return i.completer instanceof c||(i.completer&&(i.completer.destroy(),i.completer=null),i.completer=new c(i),i.once("destroy",u)),i.completer},c.startCommand={name:"startInlineAutocomplete",exec:function(i,r){c.for(i).show(r)},bindKey:{win:"Alt-C",mac:"Option-C"}};var h=[k,y,E];v("../config").defineOptions(T.prototype,"editor",{enableInlineAutocompletion:{set:function(i){i?(this.completers||(this.completers=Array.isArray(i)?i:h),this.commands.addCommand(c.startCommand)):this.commands.removeCommand(c.startCommand)},value:!1}});var t="inline_autocomplete_tooltip_entry",e="inline_autocomplete_tooltip_button",p="inline_autocomplete_tooltip",n=function(){function i(r,a){this.editor=r,this.htmlElement=document.createElement("div");var l=this.htmlElement;l.style.display="none",a&&a.appendChild(l),l.id=p,l.style["pointer-events"]="auto",l.className="ace_tooltip ace_inline_autocomplete_tooltip",this.commands={},this.buttons={},this.eventListeners={}}return i.prototype.setCommands=function(r){if(r&&this.htmlElement){this.detach();for(var a=this.htmlElement;a.hasChildNodes();)a.removeChild(a.firstChild);this.commands=r,this.buttons={},this.eventListeners={},Object.keys(r).map(function(l){return[l,r[l]]}).filter(function(l){return l[1].position>0}).sort(function(l,d){return l[1].position-d[1].position}).forEach(function(l){var d=l[0],b=l[1];I.buildDom(["div",{class:t},[["div",{class:e,ref:d},this.buttons]]],a,this.buttons);var g=b.bindKey;"object"==typeof g&&(g=A.isMac?g.mac:g.win),g=g.replace("|"," / ");var m=I.createTextNode([b.name,"(",g,")"].join(" "));this.buttons[d].appendChild(m)}.bind(this))}},i.prototype.show=function(){this.detach(),this.htmlElement.style.display="",this.htmlElement.addEventListener("mousedown",s.bind(this)),this.updatePosition(),this.updateButtons(!0)},i.prototype.isShown=function(){return!!this.htmlElement&&"none"!==window.getComputedStyle(this.htmlElement).display},i.prototype.updatePosition=function(){if(this.editor){var a,r=this.editor.renderer;if((a=this.editor.selection.getAllRanges?this.editor.selection.getAllRanges():[this.editor.getSelection()]).length){for(var b,l=f(a[0].start,a[0].end),d=0;b=a[d];d++)l=f(l,f(b.start,b.end));var g=r.$cursorLayer.getPixelPosition(l,!0),m=this.htmlElement,R=window.innerWidth,N=this.editor.container.getBoundingClientRect();g.top+=N.top-r.layerConfig.offset,g.left+=N.left-this.editor.renderer.scrollLeft,g.left+=r.gutterWidth,m.style.top=g.top-m.offsetHeight+"px",m.style.bottom="",m.style.left=Math.min(R-m.offsetWidth,g.left)+"px"}}},i.prototype.updateButtons=function(r){Object.keys(this.buttons).forEach(function(a){var l=this.commands[a].enabled;if("function"==typeof l&&(l=l(this.editor)),l&&(r||!this.eventListeners[a])){this.buttons[a].className=e,this.buttons[a].ariaDisabled=this.buttons[a].disabled=!1,this.buttons[a].removeAttribute("disabled");var d=function(b){this.commands[a].exec(this.editor),b.preventDefault()}.bind(this);this.eventListeners[a]=d,this.buttons[a].addEventListener("mousedown",d)}!l&&(r||this.eventListeners[a])&&(this.buttons[a].className=e+"_disabled",this.buttons[a].ariaDisabled=this.buttons[a].disabled=!0,this.buttons[a].setAttribute("disabled",""),this.buttons[a].removeEventListener("mousedown",this.eventListeners[a]),delete this.eventListeners[a])}.bind(this))},i.prototype.detach=function(){var r=Object.keys(this.eventListeners);this.eventListeners&&r.length&&r.forEach(function(a){this.buttons[a].removeEventListener("mousedown",this.eventListeners[a]),delete this.eventListeners[a]}.bind(this)),this.htmlElement&&(this.htmlElement.removeEventListener("mousedown",s.bind(this)),this.htmlElement.style.display="none")},i.prototype.destroy=function(){this.detach(),this.htmlElement&&this.htmlElement.parentNode.removeChild(this.htmlElement),this.editor=null,this.buttons=null,this.htmlElement=null,this.controls=null},i}(),s=function(i){i.preventDefault()};I.importCssString("\n.ace_inline_autocomplete_tooltip {\n    display: inline-block;\n}\n.".concat(t," {\n    display: inline-block;\n    padding: 0 5px;\n}\n\n.").concat(e," {\n    display: inline-block;\n    cursor: pointer;\n    padding: 5px;\n}\n\n.").concat(e,":hover {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\ndiv.").concat(e,"_disabled {\n    display: inline-block;\n    padding: 5px;\n    cursor: default;\n    color: #777;\n}"),"inlinetooltip.css",!1),w.InlineAutocomplete=c,w.InlineTooltip=n,w.TOOLTIP_ID=p,w.BUTTON_CLASS_NAME=e}),ace.require(["ace/ext/inline_autocomplete"],function(v){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=v)});