/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.datamodel.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.helix.zookeeper.zkclient.exception.ZkMarshallingError;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;

public class ChainedPathZkSerializer
implements PathBasedZkSerializer {
    private final List<ChainItem> _items;
    private final ZkSerializer _defaultSerializer;

    public static Builder builder(ZkSerializer defaultSerializer) {
        return new Builder(defaultSerializer);
    }

    private ChainedPathZkSerializer(ZkSerializer defaultSerializer, List<ChainItem> items) {
        this._items = items;
        Collections.sort(this._items);
        this._defaultSerializer = defaultSerializer;
    }

    @Override
    public byte[] serialize(Object data, String path) throws ZkMarshallingError {
        for (ChainItem item : this._items) {
            if (!item.matches(path)) continue;
            return item._serializer.serialize(data);
        }
        return this._defaultSerializer.serialize(data);
    }

    @Override
    public Object deserialize(byte[] bytes, String path) throws ZkMarshallingError {
        for (ChainItem item : this._items) {
            if (!item.matches(path)) continue;
            return item._serializer.deserialize(bytes);
        }
        return this._defaultSerializer.deserialize(bytes);
    }

    private static String normalize(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    private static class ChainItem
    implements Comparable<ChainItem> {
        final String _path;
        final ZkSerializer _serializer;

        ChainItem(String path, ZkSerializer serializer) {
            this._path = path;
            this._serializer = serializer;
        }

        boolean matches(String path) {
            if (this._path.equals(path)) {
                return true;
            }
            return path.length() > this._path.length() && path.startsWith(this._path) && path.charAt(this._path.length()) == '/';
        }

        @Override
        public int compareTo(ChainItem o) {
            return o._path.length() - this._path.length();
        }
    }

    public static class Builder {
        private final ZkSerializer _defaultSerializer;
        private List<ChainItem> _items = new ArrayList<ChainItem>();

        private Builder(ZkSerializer defaultSerializer) {
            this._defaultSerializer = defaultSerializer;
        }

        public Builder serialize(String path, ZkSerializer withSerializer) {
            this._items.add(new ChainItem(ChainedPathZkSerializer.normalize(path), withSerializer));
            return this;
        }

        public ChainedPathZkSerializer build() {
            return new ChainedPathZkSerializer(this._defaultSerializer, this._items);
        }
    }
}

