/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.Properties;
import org.apache.helix.HelixCloudProperty;
import org.apache.helix.model.CloudConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixManagerProperty {
    private static final Logger LOG = LoggerFactory.getLogger((String)HelixManagerProperty.class.getName());
    private String _version;
    private long _healthReportLatency;
    private HelixCloudProperty _helixCloudProperty;
    private InstanceConfig.Builder _defaultInstanceConfigBuilder;
    private RealmAwareZkClient.RealmAwareZkConnectionConfig _zkConnectionConfig;
    private RealmAwareZkClient.RealmAwareZkClientConfig _zkClientConfig;

    @Deprecated
    public HelixManagerProperty(Properties helixManagerProperties, CloudConfig cloudConfig) {
        this._helixCloudProperty = new HelixCloudProperty(cloudConfig);
        this._version = helixManagerProperties.getProperty("clustermanager.version");
        this._healthReportLatency = Long.parseLong(helixManagerProperties.getProperty("helixmanager.participantHealthReport.reportLatency"));
    }

    private HelixManagerProperty(String version, long healthReportLatency, HelixCloudProperty helixCloudProperty, InstanceConfig.Builder defaultInstanceConfig, RealmAwareZkClient.RealmAwareZkConnectionConfig zkConnectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig zkClientConfig) {
        this._version = version;
        this._healthReportLatency = healthReportLatency;
        this._helixCloudProperty = helixCloudProperty;
        this._defaultInstanceConfigBuilder = defaultInstanceConfig;
        this._zkConnectionConfig = zkConnectionConfig;
        this._zkClientConfig = zkClientConfig;
    }

    public HelixCloudProperty getHelixCloudProperty() {
        if (this._helixCloudProperty == null) {
            this._helixCloudProperty = new HelixCloudProperty(new CloudConfig());
        }
        return this._helixCloudProperty;
    }

    public InstanceConfig.Builder getDefaultInstanceConfigBuilder() {
        if (this._defaultInstanceConfigBuilder == null) {
            this._defaultInstanceConfigBuilder = new InstanceConfig.Builder();
        }
        return this._defaultInstanceConfigBuilder;
    }

    public String getVersion() {
        return this._version;
    }

    public long getHealthReportLatency() {
        return this._healthReportLatency;
    }

    public RealmAwareZkClient.RealmAwareZkConnectionConfig getZkConnectionConfig() {
        return this._zkConnectionConfig;
    }

    public RealmAwareZkClient.RealmAwareZkClientConfig getZkClientConfig() {
        return this._zkClientConfig;
    }

    public static class Builder {
        private String _version;
        private long _healthReportLatency;
        private HelixCloudProperty _helixCloudProperty;
        private InstanceConfig.Builder _defaultInstanceConfigBuilder;
        private RealmAwareZkClient.RealmAwareZkConnectionConfig _zkConnectionConfig;
        private RealmAwareZkClient.RealmAwareZkClientConfig _zkClientConfig;

        public HelixManagerProperty build() {
            return new HelixManagerProperty(this._version, this._healthReportLatency, this._helixCloudProperty, this._defaultInstanceConfigBuilder, this._zkConnectionConfig, this._zkClientConfig);
        }

        public Builder setVersion(String version) {
            this._version = version;
            return this;
        }

        public Builder setHealthReportLatency(long healthReportLatency) {
            this._healthReportLatency = healthReportLatency;
            return this;
        }

        public Builder setHelixCloudProperty(HelixCloudProperty helixCloudProperty) {
            this._helixCloudProperty = helixCloudProperty;
            return this;
        }

        public Builder setDefaultInstanceConfigBuilder(InstanceConfig.Builder defaultInstanceConfigBuilder) {
            this._defaultInstanceConfigBuilder = defaultInstanceConfigBuilder;
            return this;
        }

        public Builder setRealmAWareZkConnectionConfig(RealmAwareZkClient.RealmAwareZkConnectionConfig zkConnectionConfig) {
            this._zkConnectionConfig = zkConnectionConfig;
            return this;
        }

        public Builder setRealmAwareZkClientConfig(RealmAwareZkClient.RealmAwareZkClientConfig zkClientConfig) {
            this._zkClientConfig = zkClientConfig;
            return this;
        }
    }
}

