/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataSnapshot;
import org.apache.helix.model.CurrentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateSnapshot
extends AbstractDataSnapshot<CurrentState> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CurrentStateSnapshot.class.getName());
    private Set<PropertyKey> _updatedStateKeys = null;
    private Map<PropertyKey, CurrentState> _prevStateMap = null;

    public CurrentStateSnapshot(Map<PropertyKey, CurrentState> currentStateMap) {
        super(currentStateMap);
    }

    public CurrentStateSnapshot(Map<PropertyKey, CurrentState> currentStateMap, Map<PropertyKey, CurrentState> prevStateMap, Set<PropertyKey> updatedStateKeys) {
        this(currentStateMap);
        this._updatedStateKeys = Collections.unmodifiableSet(new HashSet<PropertyKey>(updatedStateKeys));
        this._prevStateMap = Collections.unmodifiableMap(new HashMap<PropertyKey, CurrentState>(prevStateMap));
    }

    public Map<PropertyKey, Map<String, Long>> getNewCurrentStateEndTimes() {
        HashMap<PropertyKey, Map<String, Long>> endTimeMap = new HashMap<PropertyKey, Map<String, Long>>();
        if (this._updatedStateKeys != null && this._prevStateMap != null) {
            int driftCnt = 0;
            for (PropertyKey propertyKey : this._updatedStateKeys) {
                CurrentState prevState = this._prevStateMap.get(propertyKey);
                CurrentState curState = (CurrentState)this._properties.get(propertyKey);
                HashMap<String, Long> partitionUpdateEndTimes = null;
                for (String partition : curState.getPartitionStateMap().keySet()) {
                    long newEndTime = curState.getEndTime(partition);
                    if ((prevState == null || prevState.getEndTime(partition) < newEndTime) && newEndTime != -1L) {
                        if (partitionUpdateEndTimes == null) {
                            partitionUpdateEndTimes = new HashMap<String, Long>();
                        }
                        partitionUpdateEndTimes.put(partition, newEndTime);
                        continue;
                    }
                    if (prevState == null || prevState.getEndTime(partition) <= newEndTime) continue;
                    if (driftCnt < 1) {
                        LOG.warn("clock drift. partition:" + partition + " curState:" + curState.getState(partition) + " prevState: " + prevState.getState(partition));
                    }
                    ++driftCnt;
                }
                if (partitionUpdateEndTimes == null) continue;
                endTimeMap.put(propertyKey, partitionUpdateEndTimes);
            }
        }
        return endTimeMap;
    }
}

