/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;

public class ResourceUsageCalculator {
    public static Map<String, Integer> getResourceUsage(ResourcesStateMap resourceAssignment, PartitionWeightProvider weightProvider) {
        HashMap<String, Integer> newParticipantUsage = new HashMap<String, Integer>();
        for (String resource : resourceAssignment.resourceSet()) {
            Map<Partition, Map<String, String>> stateMap = resourceAssignment.getPartitionStateMap(resource).getStateMap();
            for (Partition partition : stateMap.keySet()) {
                for (String participant : stateMap.get(partition).keySet()) {
                    if (!newParticipantUsage.containsKey(participant)) {
                        newParticipantUsage.put(participant, 0);
                    }
                    newParticipantUsage.put(participant, (Integer)newParticipantUsage.get(participant) + weightProvider.getPartitionWeight(resource, partition.getPartitionName()));
                }
            }
        }
        return newParticipantUsage;
    }

    public static double measureBaselineDivergence(Map<String, ResourceAssignment> baseline, Map<String, ResourceAssignment> bestPossibleAssignment) {
        int numMatchedReplicas = 0;
        int numTotalBestPossibleReplicas = 0;
        for (Map.Entry<String, ResourceAssignment> resourceEntry : bestPossibleAssignment.entrySet()) {
            String resourceKey = resourceEntry.getKey();
            if (!baseline.containsKey(resourceKey)) continue;
            Map<String, Map<String, String>> bestPossiblePartitions = resourceEntry.getValue().getRecord().getMapFields();
            Map<String, Map<String, String>> baselinePartitions = baseline.get(resourceKey).getRecord().getMapFields();
            for (Map.Entry<String, Map<String, String>> partitionEntry : bestPossiblePartitions.entrySet()) {
                String partitionName = partitionEntry.getKey();
                if (!baselinePartitions.containsKey(partitionName)) continue;
                Map<String, String> bestPossibleReplicas = partitionEntry.getValue();
                Map<String, String> baselineReplicas = baselinePartitions.get(partitionName);
                for (Map.Entry<String, String> replicaEntry : bestPossibleReplicas.entrySet()) {
                    String baselineReplica;
                    String bestPossibleReplica;
                    String replicaName = replicaEntry.getKey();
                    if (!baselineReplicas.containsKey(replicaName) || !(bestPossibleReplica = replicaEntry.getValue()).equals(baselineReplica = baselineReplicas.get(replicaName))) continue;
                    ++numMatchedReplicas;
                }
                numTotalBestPossibleReplicas += bestPossibleReplicas.size();
            }
        }
        return numTotalBestPossibleReplicas == 0 ? 1.0 : 1.0 - (double)numMatchedReplicas / (double)numTotalBestPossibleReplicas;
    }

    public static Map<String, Integer> calculateAveragePartitionWeight(Map<String, Map<String, Integer>> partitionCapacityMap) {
        HashMap countPartitionWeightMap = new HashMap();
        partitionCapacityMap.values().forEach(partitionCapacityEntry -> partitionCapacityEntry.forEach((capacityKey, weight) -> countPartitionWeightMap.computeIfAbsent(capacityKey, counterEntry -> new PartitionWeightCounterEntry()).increase(1, (int)weight)));
        HashMap<String, Integer> averagePartitionWeightMap = new HashMap<String, Integer>();
        for (Map.Entry entry : countPartitionWeightMap.entrySet()) {
            String capacityKey = (String)entry.getKey();
            PartitionWeightCounterEntry weightEntry = (PartitionWeightCounterEntry)entry.getValue();
            int averageWeight = (int)(weightEntry.getWeight() / (long)weightEntry.getPartitions());
            averagePartitionWeightMap.put(capacityKey, averageWeight);
        }
        return averagePartitionWeightMap;
    }

    private static class PartitionWeightCounterEntry {
        private int partitions;
        private long weight;

        private PartitionWeightCounterEntry() {
        }

        private int getPartitions() {
            return this.partitions;
        }

        private long getWeight() {
            return this.weight;
        }

        private void increase(int partitions, int weight) {
            this.partitions += partitions;
            this.weight += (long)weight;
        }
    }
}

