/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.dataproviders.InstanceCapacityDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.WagedResourceWeightsProvider;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagedInstanceCapacity
implements InstanceCapacityDataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WagedInstanceCapacity.class);
    private final Map<String, Map<String, Integer>> _instanceCapacityMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Set<String>>> _allocatedPartitionsMap = new HashMap<String, Map<String, Set<String>>>();

    public WagedInstanceCapacity(ResourceControllerDataProvider clusterData) {
        ClusterConfig clusterConfig = clusterData.getClusterConfig();
        if (clusterConfig == null) {
            LOG.error("Cluster config is null, cannot initialize instance capacity map.");
            return;
        }
        for (InstanceConfig instanceConfig : clusterData.getInstanceConfigMap().values()) {
            Map<String, Integer> instanceCapacity = WagedValidationUtil.validateAndGetInstanceCapacity(clusterConfig, instanceConfig);
            this._instanceCapacityMap.put(instanceConfig.getInstanceName(), instanceCapacity);
            this._allocatedPartitionsMap.put(instanceConfig.getInstanceName(), new HashMap());
        }
    }

    private boolean hasPartitionChargedForCapacity(String instance, String resource, String partition) {
        if (!this._allocatedPartitionsMap.containsKey(instance)) {
            this._allocatedPartitionsMap.put(instance, new HashMap());
            return false;
        }
        return this._allocatedPartitionsMap.get(instance).containsKey(resource) && this._allocatedPartitionsMap.get(instance).get(resource).contains(partition);
    }

    public void process(ResourceControllerDataProvider cache, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap, WagedResourceWeightsProvider weightProvider) {
        this.processCurrentState(cache, currentStateOutput, resourceMap, weightProvider);
        this.processPendingMessages(cache, resourceMap, weightProvider);
    }

    public void processPendingMessages(ResourceControllerDataProvider cache, Map<String, Resource> resourceMap, WagedResourceWeightsProvider weightProvider) {
        Set<String> liveInstances = cache.getEnabledLiveInstances();
        Map<String, Collection<Message>> messages = cache.getAllInstancesMessages();
        for (String instance : liveInstances) {
            Collection<Message> msgs = messages.get(instance);
            if (msgs == null || msgs.isEmpty()) continue;
            for (Message msg : msgs) {
                String resName;
                if (!msg.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) || !resourceMap.containsKey(resName = msg.getResourceName()) || !WagedValidationUtil.isWagedEnabled(cache.getIdealState(resName))) continue;
                Resource resource = resourceMap.get(resName);
                StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
                Map<String, Integer> statePriorityMap = stateModelDef.getStatePriorityMap();
                String partitionName = msg.getPartitionName();
                Map<String, Integer> partCapacity = weightProvider.getPartitionWeights(resName, partitionName);
                if (partCapacity == null || partCapacity.isEmpty()) {
                    LOG.debug("Partition: " + partitionName + " in resource: " + resName + " has no weight specified. Skipping it.");
                    continue;
                }
                if (statePriorityMap.get(msg.getFromState()) <= statePriorityMap.get(msg.getToState()) || !msg.getFromState().equals(stateModelDef.getInitialState())) continue;
                LOG.info("For bootstrapping - deducting capacity for instance: " + instance + " for resource: " + resName + " for partition: " + partitionName);
                this.checkAndReduceInstanceCapacity(instance, resName, partitionName, partCapacity);
            }
        }
    }

    private void processCurrentState(ResourceControllerDataProvider cache, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap, WagedResourceWeightsProvider weightProvider) {
        for (Map.Entry<String, Resource> entry : resourceMap.entrySet()) {
            String resName = entry.getKey();
            Resource resource = entry.getValue();
            if (!WagedValidationUtil.isWagedEnabled(cache.getIdealState(resName))) continue;
            Collection<Partition> partitions = resource.getPartitions();
            for (Partition partition : partitions) {
                String partitionName = partition.getPartitionName();
                Map<String, Integer> partCapacity = weightProvider.getPartitionWeights(resName, partitionName);
                Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resName, partition);
                if (currentStateMap == null || currentStateMap.isEmpty()) continue;
                for (String instance : currentStateMap.keySet()) {
                    this.checkAndReduceInstanceCapacity(instance, resName, partitionName, partCapacity);
                }
            }
        }
    }

    @Override
    public Map<String, Integer> getInstanceAvailableCapacity(String instanceName) {
        return this._instanceCapacityMap.get(instanceName);
    }

    @Override
    public boolean isInstanceCapacityAvailable(String instance, Map<String, Integer> partitionCapacity) {
        Map<String, Integer> instanceCapacity = this._instanceCapacityMap.get(instance);
        for (String key : instanceCapacity.keySet()) {
            int partCapacity = partitionCapacity.getOrDefault(key, 0);
            if (partCapacity == 0 || instanceCapacity.get(key) >= partCapacity) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean checkAndReduceInstanceCapacity(String instance, String resName, String partitionName, Map<String, Integer> partitionCapacity) {
        if (this.hasPartitionChargedForCapacity(instance, resName, partitionName)) {
            LOG.debug("Instance: " + instance + " for resource: " + resName + " for partition: " + partitionName + " already charged for capacity.");
            return true;
        }
        Map<String, Integer> instanceCapacity = this._instanceCapacityMap.get(instance);
        HashMap<String, Integer> processedCapacity = new HashMap<String, Integer>();
        for (String key : instanceCapacity.keySet()) {
            if (!partitionCapacity.containsKey(key)) continue;
            int partCapacity = partitionCapacity.get(key);
            if (instanceCapacity.get(key) < partCapacity) {
                for (String processedKey : processedCapacity.keySet()) {
                    instanceCapacity.put(processedKey, instanceCapacity.get(processedKey) + (Integer)processedCapacity.get(processedKey));
                }
                return false;
            }
            instanceCapacity.put(key, instanceCapacity.get(key) - partCapacity);
            processedCapacity.put(key, partCapacity);
        }
        this._allocatedPartitionsMap.computeIfAbsent(instance, k -> new HashMap()).computeIfAbsent(resName, k -> new HashSet()).add(partitionName);
        LOG.info("Reduced capacity for instance: " + instance + " for resource: " + resName + " for partition: " + partitionName);
        return true;
    }
}

