/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusterContext.class.getName());
    private final int _estimatedMaxPartitionCount;
    private final int _estimatedMaxTopStateCount;
    private final Map<String, Integer> _estimatedMaxPartitionByResource = new HashMap<String, Integer>();
    private final float _estimatedMaxUtilization;
    private final float _estimatedTopStateMaxUtilization;
    private Map<String, Map<String, Set<String>>> _assignmentForFaultZoneMap = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, ResourceAssignment> _baselineAssignment;
    private final Map<String, ResourceAssignment> _bestPossibleAssignment;
    private final Map<String, Integer> _estimateUtilizationMap;
    private final Map<String, Integer> _clusterCapacityMap;
    private final List<String> _preferredScoringKeys;
    private final String _clusterName;

    ClusterContext(Set<AssignableReplica> replicaSet, Set<AssignableNode> nodeSet, Map<String, ResourceAssignment> baselineAssignment, Map<String, ResourceAssignment> bestPossibleAssignment) {
        this(replicaSet, nodeSet, baselineAssignment, bestPossibleAssignment, null);
    }

    ClusterContext(Set<AssignableReplica> replicaSet, Set<AssignableNode> nodeSet, Map<String, ResourceAssignment> baselineAssignment, Map<String, ResourceAssignment> bestPossibleAssignment, ClusterConfig clusterConfig) {
        int instanceCount = nodeSet.size();
        int totalReplicas = 0;
        int totalTopStateReplicas = 0;
        HashMap<String, Integer> totalUsage = new HashMap<String, Integer>();
        HashMap<String, Integer> totalTopStateUsage = new HashMap<String, Integer>();
        HashMap<String, Integer> totalCapacity = new HashMap<String, Integer>();
        this._preferredScoringKeys = Optional.ofNullable(clusterConfig).map(ClusterConfig::getPreferredScoringKeys).orElse(null);
        this._clusterName = Optional.ofNullable(clusterConfig).map(ClusterConfig::getClusterName).orElse(null);
        for (Map.Entry<String, List<AssignableReplica>> entry : replicaSet.stream().collect(Collectors.groupingBy(AssignableReplica::getResourceName)).entrySet()) {
            int replicas = entry.getValue().size();
            totalReplicas += replicas;
            int replicaCnt = Math.max(1, ClusterContext.estimateAvgReplicaCount(replicas, instanceCount));
            this._estimatedMaxPartitionByResource.put(entry.getKey(), replicaCnt);
            for (AssignableReplica replica : entry.getValue()) {
                if (replica.isReplicaTopState()) {
                    ++totalTopStateReplicas;
                    replica.getCapacity().forEach((key, value) -> totalTopStateUsage.compute((String)key, (k, v) -> v == null ? value : v + value));
                }
                replica.getCapacity().forEach((key, value) -> totalUsage.compute((String)key, (k, v) -> v == null ? value : v + value));
            }
        }
        nodeSet.forEach(node -> node.getMaxCapacity().forEach((key, value) -> totalCapacity.compute((String)key, (k, v) -> v == null ? value : v + value)));
        if (totalCapacity.isEmpty()) {
            this._estimatedMaxUtilization = 1.0f;
            this._estimatedTopStateMaxUtilization = 1.0f;
            this._estimateUtilizationMap = Collections.emptyMap();
            this._clusterCapacityMap = Collections.emptyMap();
        } else {
            this._estimatedMaxUtilization = ClusterContext.estimateMaxUtilization(totalCapacity, totalUsage, this._preferredScoringKeys);
            this._estimatedTopStateMaxUtilization = ClusterContext.estimateMaxUtilization(totalCapacity, totalTopStateUsage, this._preferredScoringKeys);
            this._estimateUtilizationMap = ClusterContext.estimateUtilization(totalCapacity, totalUsage);
            this._clusterCapacityMap = Collections.unmodifiableMap(totalCapacity);
        }
        LOG.info("clusterName: {}, preferredScoringKeys: {}, estimatedMaxUtilization: {}, estimatedTopStateMaxUtilization: {}", new Object[]{this._clusterName, this._preferredScoringKeys, Float.valueOf(this._estimatedMaxUtilization), Float.valueOf(this._estimatedTopStateMaxUtilization)});
        this._estimatedMaxPartitionCount = ClusterContext.estimateAvgReplicaCount(totalReplicas, instanceCount);
        this._estimatedMaxTopStateCount = ClusterContext.estimateAvgReplicaCount(totalTopStateReplicas, instanceCount);
        this._baselineAssignment = baselineAssignment;
        this._bestPossibleAssignment = bestPossibleAssignment;
    }

    public List<String> getPreferredScoringKeys() {
        return this._preferredScoringKeys;
    }

    public Map<String, ResourceAssignment> getBaselineAssignment() {
        return this._baselineAssignment == null || this._baselineAssignment.isEmpty() ? Collections.emptyMap() : this._baselineAssignment;
    }

    public Map<String, ResourceAssignment> getBestPossibleAssignment() {
        return this._bestPossibleAssignment == null || this._bestPossibleAssignment.isEmpty() ? Collections.emptyMap() : this._bestPossibleAssignment;
    }

    public Map<String, Map<String, Set<String>>> getAssignmentForFaultZoneMap() {
        return this._assignmentForFaultZoneMap;
    }

    public int getEstimatedMaxPartitionCount() {
        return this._estimatedMaxPartitionCount;
    }

    public int getEstimatedMaxPartitionByResource(String resourceName) {
        return this._estimatedMaxPartitionByResource.get(resourceName);
    }

    public int getEstimatedMaxTopStateCount() {
        return this._estimatedMaxTopStateCount;
    }

    public float getEstimatedMaxUtilization() {
        return this._estimatedMaxUtilization;
    }

    public float getEstimatedTopStateMaxUtilization() {
        return this._estimatedTopStateMaxUtilization;
    }

    public Map<String, Integer> getEstimateUtilizationMap() {
        return this._estimateUtilizationMap;
    }

    public Map<String, Integer> getClusterCapacityMap() {
        return this._clusterCapacityMap;
    }

    public Set<String> getPartitionsForResourceAndFaultZone(String resourceName, String faultZoneId) {
        return this._assignmentForFaultZoneMap.getOrDefault(faultZoneId, Collections.emptyMap()).getOrDefault(resourceName, Collections.emptySet());
    }

    void addPartitionToFaultZone(String faultZoneId, String resourceName, String partition) {
        if (!this._assignmentForFaultZoneMap.computeIfAbsent(faultZoneId, k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashSet()).add(partition)) {
            throw new HelixException(String.format("Resource %s already has a replica from partition %s in fault zone %s", resourceName, partition, faultZoneId));
        }
    }

    boolean removePartitionFromFaultZone(String faultZoneId, String resourceName, String partition) {
        return this._assignmentForFaultZoneMap.getOrDefault(faultZoneId, Collections.emptyMap()).getOrDefault(resourceName, Collections.emptySet()).remove(partition);
    }

    void setAssignmentForFaultZoneMap(Map<String, Map<String, Set<String>>> assignmentForFaultZoneMap) {
        this._assignmentForFaultZoneMap = assignmentForFaultZoneMap;
    }

    private static int estimateAvgReplicaCount(int replicaCount, int instanceCount) {
        return (int)Math.floor((float)replicaCount / (float)instanceCount);
    }

    private static float estimateMaxUtilization(Map<String, Integer> totalCapacity, Map<String, Integer> totalUsage, List<String> preferredScoringKeys) {
        float estimatedMaxUsage = 0.0f;
        Set<String> capacityKeySet = totalCapacity.keySet();
        if (preferredScoringKeys != null && preferredScoringKeys.size() != 0 && capacityKeySet.contains(preferredScoringKeys.get(0))) {
            capacityKeySet = preferredScoringKeys.stream().collect(Collectors.toSet());
        }
        for (String capacityKey : capacityKeySet) {
            int maxCapacity = totalCapacity.get(capacityKey);
            int usage = totalUsage.getOrDefault(capacityKey, 0);
            float utilization = maxCapacity == 0 ? 1.0f : (float)usage / (float)maxCapacity;
            estimatedMaxUsage = Math.max(estimatedMaxUsage, utilization);
        }
        return estimatedMaxUsage;
    }

    private static Map<String, Integer> estimateUtilization(Map<String, Integer> totalCapacity, Map<String, Integer> totalUsage) {
        HashMap<String, Integer> estimateUtilization = new HashMap<String, Integer>();
        for (String capacityKey : totalCapacity.keySet()) {
            int maxCapacity = totalCapacity.get(capacityKey);
            int usage = totalUsage.getOrDefault(capacityKey, 0);
            estimateUtilization.put(capacityKey, maxCapacity - usage);
        }
        return Collections.unmodifiableMap(estimateUtilization);
    }
}

