/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.helix.controller.rebalancer.waged.constraints.SoftConstraint;

abstract class UsageSoftConstraint
extends SoftConstraint {
    private static final double MAX_SCORE = 1.0;
    private static final double MIN_SCORE = 0.0;
    private static final int DEFAULT_ALPHA = 44;
    private static final Sigmoid SIGMOID = new Sigmoid();

    UsageSoftConstraint() {
        super(1.0, 0.0);
    }

    protected double computeUtilizationScore(double estimatedUsage, double currentUsage) {
        if (estimatedUsage == 0.0) {
            return 0.0;
        }
        return currentUsage / estimatedUsage;
    }

    @Override
    protected SoftConstraint.NormalizeFunction getNormalizeFunction() {
        return score -> SIGMOID.value(-(score - 1.0) * 44.0) * 1.0;
    }
}

