/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.UsageSoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class ResourcePartitionAntiAffinityConstraint
extends UsageSoftConstraint {
    ResourcePartitionAntiAffinityConstraint() {
    }

    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        String resource = replica.getResourceName();
        int curPartitionCountForResource = node.getAssignedPartitionsByResource(resource).size();
        int estimatedMaxPartitionCountForResource = clusterContext.getEstimatedMaxPartitionByResource(resource);
        return this.computeUtilizationScore(estimatedMaxPartitionCountForResource, curPartitionCountForResource);
    }
}

