/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.ExternalViewCache;
import org.apache.helix.common.caches.PropertyCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicClusterDataCache
implements ControlContextProvider {
    private static Logger LOG = LoggerFactory.getLogger((String)BasicClusterDataCache.class.getName());
    private static final String INSTANCE_CONFIG = "InstanceConfig";
    private static final String LIVE_INSTANCE = "LiveInstance";
    private String _clusterEventId;
    protected PropertyCache<LiveInstance> _liveInstancePropertyCache;
    protected PropertyCache<InstanceConfig> _instanceConfigPropertyCache;
    protected ExternalViewCache _externalViewCache;
    protected String _clusterName;
    protected Map<HelixConstants.ChangeType, Boolean> _propertyDataChangedMap = new ConcurrentHashMap<HelixConstants.ChangeType, Boolean>();

    public BasicClusterDataCache(String clusterName) {
        this._externalViewCache = new ExternalViewCache(clusterName);
        this._clusterName = clusterName;
        this._clusterEventId = "NO_ID";
        this._liveInstancePropertyCache = new PropertyCache<LiveInstance>(this, LIVE_INSTANCE, new PropertyCache.PropertyCacheKeyFuncs<LiveInstance>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().liveInstances();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().liveInstance(objName);
            }

            @Override
            public String getObjName(LiveInstance obj) {
                return obj.getInstanceName();
            }
        }, true);
        this._instanceConfigPropertyCache = new PropertyCache<InstanceConfig>(this, INSTANCE_CONFIG, new PropertyCache.PropertyCacheKeyFuncs<InstanceConfig>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().instanceConfigs();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().instanceConfig(objName);
            }

            @Override
            public String getObjName(InstanceConfig obj) {
                return obj.getInstanceName();
            }
        }, true);
    }

    public void refresh(HelixDataAccessor accessor) {
        long start;
        LOG.info("START: BasicClusterDataCache.refresh() for cluster " + this._clusterName);
        long startTime = System.currentTimeMillis();
        if (this._propertyDataChangedMap.getOrDefault((Object)HelixConstants.ChangeType.EXTERNAL_VIEW, false).booleanValue()) {
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.EXTERNAL_VIEW, false);
            this._externalViewCache.refresh(accessor);
        }
        if (this._propertyDataChangedMap.getOrDefault((Object)HelixConstants.ChangeType.LIVE_INSTANCE, false).booleanValue()) {
            start = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.LIVE_INSTANCE, false);
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.CURRENT_STATE, true);
            this._liveInstancePropertyCache.refresh(accessor);
            LOG.info("Reload LiveInstances: " + this._liveInstancePropertyCache.getPropertyMap().keySet() + ". Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        if (this._propertyDataChangedMap.getOrDefault((Object)HelixConstants.ChangeType.INSTANCE_CONFIG, false).booleanValue()) {
            start = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.INSTANCE_CONFIG, false);
            this._instanceConfigPropertyCache.refresh(accessor);
            LOG.info("Reload InstanceConfig: " + this._instanceConfigPropertyCache.getPropertyMap().keySet() + ". Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        long endTime = System.currentTimeMillis();
        LOG.info("END: BasicClusterDataCache.refresh() for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
        LOG.debug("LiveInstances: {}", this._liveInstancePropertyCache.getPropertyMap());
        LOG.debug("ExternalViews: {}", this._externalViewCache.getExternalViewMap().keySet());
        LOG.debug("InstanceConfigs: {}", this._instanceConfigPropertyCache.getPropertyMap());
    }

    public Map<String, ExternalView> getExternalViews() {
        return this._externalViewCache.getExternalViewMap();
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return this._liveInstancePropertyCache.getPropertyMap();
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._instanceConfigPropertyCache.getPropertyMap();
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType, String pathChanged) {
        this.notifyDataChange(changeType);
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType) {
        this._propertyDataChangedMap.put(changeType, true);
    }

    public synchronized void clearCache(HelixConstants.ChangeType changeType) {
        switch (changeType) {
            case LIVE_INSTANCE: {
                this._liveInstancePropertyCache.setPropertyMap(HelixProperty.convertListToMap(Collections.emptyList()));
                break;
            }
            case INSTANCE_CONFIG: {
                this._instanceConfigPropertyCache.setPropertyMap(HelixProperty.convertListToMap(Collections.emptyList()));
                break;
            }
            case EXTERNAL_VIEW: {
                this._externalViewCache.clear();
                break;
            }
        }
    }

    public void requireFullRefresh() {
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            this._propertyDataChangedMap.put(type, Boolean.TRUE);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liveInstancePropertyCache: ").append(this._liveInstancePropertyCache.getPropertyMap()).append("\n");
        sb.append("externalViewCache: ").append(this._externalViewCache.getExternalViewMap()).append("\n");
        sb.append("instanceConfigPropertyCache: ").append(this._instanceConfigPropertyCache.getPropertyMap()).append("\n");
        return sb.toString();
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public String getClusterEventId() {
        return this._clusterEventId;
    }

    @Override
    public void setClusterEventId(String clusterEventId) {
        this._clusterEventId = clusterEventId;
    }

    @Override
    public String getPipelineName() {
        return "UNKNOWN_PIPELINE";
    }
}

