/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CapacityNode {
    private int _currentlyAssigned = 0;
    private int _capacity;
    private final String _id;
    private final Map<String, Set<String>> _partitionMap = new HashMap<String, Set<String>>();

    public CapacityNode(String id) {
        this._id = id;
    }

    public boolean canAdd(String resource, String partition) {
        if (this._currentlyAssigned >= this._capacity || this._partitionMap.containsKey(resource) && this._partitionMap.get(resource).contains(partition)) {
            return false;
        }
        this._partitionMap.computeIfAbsent(resource, k -> new HashSet()).add(partition);
        ++this._currentlyAssigned;
        return true;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
    }

    public String getId() {
        return this._id;
    }

    public int getCurrentlyAssigned() {
        return this._currentlyAssigned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("##########\nname=").append(this._id).append("\nassigned:").append(this._currentlyAssigned).append("\ncapacity:").append(this._capacity);
        return sb.toString();
    }
}

