/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class StorageSchemataSMD
extends StateModelDefinition {
    public static final String name = "STORAGE_DEFAULT_SM_SCHEMATA";

    public StorageSchemataSMD() {
        super(StorageSchemataSMD.generateConfigForStorageSchemata());
    }

    public static StateModelDefinition build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(name);
        builder.initialState(States.OFFLINE.name());
        builder.addState(States.MASTER.name(), 0);
        builder.addState(States.OFFLINE.name(), 1);
        for (HelixDefinedState state : HelixDefinedState.values()) {
            builder.addState(state.name());
        }
        builder.addTransition(States.MASTER.name(), States.OFFLINE.name(), 0);
        builder.addTransition(States.OFFLINE.name(), States.MASTER.name(), 1);
        builder.addTransition(States.OFFLINE.name(), HelixDefinedState.DROPPED.name());
        builder.dynamicUpperBound(States.MASTER.name(), "N");
        return builder.build();
    }

    @Deprecated
    public static ZNRecord generateConfigForStorageSchemata() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord(name);
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("MASTER");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        statePriorityList.add("ERROR");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("MASTER")) {
                metadata.put("count", "N");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("DROPPED")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (!state.equals("ERROR")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("MASTER")) {
                metadata = new HashMap();
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata = new HashMap();
                metadata.put("MASTER", "MASTER");
                metadata.put("DROPPED", "DROPPED");
                record.setMapField(key, metadata);
            }
            if (!state.equals("ERROR")) continue;
            metadata = new HashMap();
            metadata.put("OFFLINE", "OFFLINE");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("MASTER-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-MASTER");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public static enum States {
        MASTER,
        OFFLINE;

    }
}

