/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.builder.ConstraintItemBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConstraintsBuilder {
    private static Logger LOG = LoggerFactory.getLogger(ClusterConstraintsBuilder.class);
    private final ClusterConstraints.ConstraintType _constraintType;
    private final Map<String, ConstraintItemBuilder> _constraintBuilderMap = new HashMap<String, ConstraintItemBuilder>();

    public ClusterConstraintsBuilder(ClusterConstraints.ConstraintType type) {
        if (type == null) {
            throw new IllegalArgumentException("constraint-type should NOT be null");
        }
        this._constraintType = type;
    }

    public ClusterConstraintsBuilder addConstraintAttribute(String constraintId, String attribute, String value) {
        if (!this._constraintBuilderMap.containsKey(constraintId)) {
            this._constraintBuilderMap.put(constraintId, new ConstraintItemBuilder());
        }
        ConstraintItemBuilder builder = this._constraintBuilderMap.get(constraintId);
        builder.addConstraintAttribute(attribute, value);
        return this;
    }

    public ClusterConstraints build() {
        ClusterConstraints constraints = new ClusterConstraints(this._constraintType);
        for (String constraintId : this._constraintBuilderMap.keySet()) {
            ConstraintItemBuilder builder = this._constraintBuilderMap.get(constraintId);
            constraints.addConstraintItem(constraintId, builder.build());
        }
        return constraints;
    }
}

