/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class FetchRequestDataJsonConverter {
    public static FetchRequestData read(JsonNode _node, short _version) {
        FetchRequestData _object = new FetchRequestData();
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            _object.clusterId = null;
        } else if (_clusterIdNode.isNull()) {
            _object.clusterId = null;
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("FetchRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        JsonNode _replicaIdNode = _node.get("replicaId");
        if (_replicaIdNode == null) {
            if (_version <= 14) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'replicaId', which is mandatory in version " + _version);
            }
            _object.replicaId = -1;
        } else {
            _object.replicaId = MessageUtil.jsonNodeToInt(_replicaIdNode, "FetchRequestData");
        }
        JsonNode _replicaStateNode = _node.get("replicaState");
        _object.replicaState = _replicaStateNode == null ? new FetchRequestData.ReplicaState() : ReplicaStateJsonConverter.read(_replicaStateNode, _version);
        JsonNode _maxWaitMsNode = _node.get("maxWaitMs");
        if (_maxWaitMsNode == null) {
            throw new RuntimeException("FetchRequestData: unable to locate field 'maxWaitMs', which is mandatory in version " + _version);
        }
        _object.maxWaitMs = MessageUtil.jsonNodeToInt(_maxWaitMsNode, "FetchRequestData");
        JsonNode _minBytesNode = _node.get("minBytes");
        if (_minBytesNode == null) {
            throw new RuntimeException("FetchRequestData: unable to locate field 'minBytes', which is mandatory in version " + _version);
        }
        _object.minBytes = MessageUtil.jsonNodeToInt(_minBytesNode, "FetchRequestData");
        JsonNode _maxBytesNode = _node.get("maxBytes");
        if (_maxBytesNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'maxBytes', which is mandatory in version " + _version);
            }
            _object.maxBytes = Integer.MAX_VALUE;
        } else {
            _object.maxBytes = MessageUtil.jsonNodeToInt(_maxBytesNode, "FetchRequestData");
        }
        JsonNode _isolationLevelNode = _node.get("isolationLevel");
        if (_isolationLevelNode == null) {
            if (_version >= 4) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'isolationLevel', which is mandatory in version " + _version);
            }
            _object.isolationLevel = 0;
        } else {
            _object.isolationLevel = MessageUtil.jsonNodeToByte(_isolationLevelNode, "FetchRequestData");
        }
        JsonNode _sessionIdNode = _node.get("sessionId");
        if (_sessionIdNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'sessionId', which is mandatory in version " + _version);
            }
            _object.sessionId = 0;
        } else {
            _object.sessionId = MessageUtil.jsonNodeToInt(_sessionIdNode, "FetchRequestData");
        }
        JsonNode _sessionEpochNode = _node.get("sessionEpoch");
        if (_sessionEpochNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'sessionEpoch', which is mandatory in version " + _version);
            }
            _object.sessionEpoch = -1;
        } else {
            _object.sessionEpoch = MessageUtil.jsonNodeToInt(_sessionEpochNode, "FetchRequestData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("FetchRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("FetchRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<FetchRequestData.FetchTopic> _collection = new ArrayList<FetchRequestData.FetchTopic>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(FetchTopicJsonConverter.read(_element, _version));
        }
        JsonNode _forgottenTopicsDataNode = _node.get("forgottenTopicsData");
        if (_forgottenTopicsDataNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'forgottenTopicsData', which is mandatory in version " + _version);
            }
            _object.forgottenTopicsData = new ArrayList<FetchRequestData.ForgottenTopic>(0);
        } else {
            if (!_forgottenTopicsDataNode.isArray()) {
                throw new RuntimeException("FetchRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<FetchRequestData.ForgottenTopic> _collection2 = new ArrayList<FetchRequestData.ForgottenTopic>(_forgottenTopicsDataNode.size());
            _object.forgottenTopicsData = _collection2;
            for (JsonNode _element : _forgottenTopicsDataNode) {
                _collection2.add(ForgottenTopicJsonConverter.read(_element, _version));
            }
        }
        JsonNode _rackIdNode = _node.get("rackId");
        if (_rackIdNode == null) {
            if (_version >= 11) {
                throw new RuntimeException("FetchRequestData: unable to locate field 'rackId', which is mandatory in version " + _version);
            }
            _object.rackId = "";
        } else {
            if (!_rackIdNode.isTextual()) {
                throw new RuntimeException("FetchRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.rackId = _rackIdNode.asText();
        }
        return _object;
    }

    public static JsonNode write(FetchRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 12 && _object.clusterId != null) {
            _node.set("clusterId", (JsonNode)new TextNode(_object.clusterId));
        }
        if (_version <= 14) {
            _node.set("replicaId", (JsonNode)new IntNode(_object.replicaId));
        } else if (_object.replicaId != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default replicaId at version " + _version);
        }
        if (_version >= 15) {
            if (!_object.replicaState.equals(new FetchRequestData.ReplicaState())) {
                _node.set("replicaState", ReplicaStateJsonConverter.write(_object.replicaState, _version, _serializeRecords));
            }
        } else if (!_object.replicaState.equals(new FetchRequestData.ReplicaState())) {
            throw new UnsupportedVersionException("Attempted to write a non-default replicaState at version " + _version);
        }
        _node.set("maxWaitMs", (JsonNode)new IntNode(_object.maxWaitMs));
        _node.set("minBytes", (JsonNode)new IntNode(_object.minBytes));
        if (_version >= 3) {
            _node.set("maxBytes", (JsonNode)new IntNode(_object.maxBytes));
        }
        if (_version >= 4) {
            _node.set("isolationLevel", (JsonNode)new ShortNode((short)_object.isolationLevel));
        }
        if (_version >= 7) {
            _node.set("sessionId", (JsonNode)new IntNode(_object.sessionId));
        }
        if (_version >= 7) {
            _node.set("sessionEpoch", (JsonNode)new IntNode(_object.sessionEpoch));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (FetchRequestData.FetchTopic _element : _object.topics) {
            _topicsArray.add(FetchTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        if (_version >= 7) {
            ArrayNode _forgottenTopicsDataArray = new ArrayNode(JsonNodeFactory.instance);
            for (FetchRequestData.ForgottenTopic _element : _object.forgottenTopicsData) {
                _forgottenTopicsDataArray.add(ForgottenTopicJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("forgottenTopicsData", (JsonNode)_forgottenTopicsDataArray);
        } else if (!_object.forgottenTopicsData.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default forgottenTopicsData at version " + _version);
        }
        if (_version >= 11) {
            _node.set("rackId", (JsonNode)new TextNode(_object.rackId));
        }
        return _node;
    }

    public static JsonNode write(FetchRequestData _object, short _version) {
        return FetchRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class ReplicaStateJsonConverter {
        public static FetchRequestData.ReplicaState read(JsonNode _node, short _version) {
            FetchRequestData.ReplicaState _object = new FetchRequestData.ReplicaState();
            if (_version < 15) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaState");
            }
            JsonNode _replicaIdNode = _node.get("replicaId");
            if (_replicaIdNode == null) {
                throw new RuntimeException("ReplicaState: unable to locate field 'replicaId', which is mandatory in version " + _version);
            }
            _object.replicaId = MessageUtil.jsonNodeToInt(_replicaIdNode, "ReplicaState");
            JsonNode _replicaEpochNode = _node.get("replicaEpoch");
            if (_replicaEpochNode == null) {
                throw new RuntimeException("ReplicaState: unable to locate field 'replicaEpoch', which is mandatory in version " + _version);
            }
            _object.replicaEpoch = MessageUtil.jsonNodeToLong(_replicaEpochNode, "ReplicaState");
            return _object;
        }

        public static JsonNode write(FetchRequestData.ReplicaState _object, short _version, boolean _serializeRecords) {
            if (_version < 15) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ReplicaState");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("replicaId", (JsonNode)new IntNode(_object.replicaId));
            _node.set("replicaEpoch", (JsonNode)new LongNode(_object.replicaEpoch));
            return _node;
        }

        public static JsonNode write(FetchRequestData.ReplicaState _object, short _version) {
            return ReplicaStateJsonConverter.write(_object, _version, true);
        }
    }

    public static class ForgottenTopicJsonConverter {
        public static FetchRequestData.ForgottenTopic read(JsonNode _node, short _version) {
            FetchRequestData.ForgottenTopic _object = new FetchRequestData.ForgottenTopic();
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ForgottenTopic");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                if (_version <= 12) {
                    throw new RuntimeException("ForgottenTopic: unable to locate field 'topic', which is mandatory in version " + _version);
                }
                _object.topic = "";
            } else {
                if (!_topicNode.isTextual()) {
                    throw new RuntimeException("ForgottenTopic expected a string type, but got " + _node.getNodeType());
                }
                _object.topic = _topicNode.asText();
            }
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                if (_version >= 13) {
                    throw new RuntimeException("ForgottenTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
                }
                _object.topicId = Uuid.ZERO_UUID;
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("ForgottenTopic expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ForgottenTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ForgottenTopic expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "ForgottenTopic element"));
            }
            return _object;
        }

        public static JsonNode write(FetchRequestData.ForgottenTopic _object, short _version, boolean _serializeRecords) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ForgottenTopic");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_version <= 12) {
                _node.set("topic", (JsonNode)new TextNode(_object.topic));
            }
            if (_version >= 13) {
                _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            }
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(FetchRequestData.ForgottenTopic _object, short _version) {
            return ForgottenTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class FetchTopicJsonConverter {
        public static FetchRequestData.FetchTopic read(JsonNode _node, short _version) {
            FetchRequestData.FetchTopic _object = new FetchRequestData.FetchTopic();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                if (_version <= 12) {
                    throw new RuntimeException("FetchTopic: unable to locate field 'topic', which is mandatory in version " + _version);
                }
                _object.topic = "";
            } else {
                if (!_topicNode.isTextual()) {
                    throw new RuntimeException("FetchTopic expected a string type, but got " + _node.getNodeType());
                }
                _object.topic = _topicNode.asText();
            }
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                if (_version >= 13) {
                    throw new RuntimeException("FetchTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
                }
                _object.topicId = Uuid.ZERO_UUID;
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("FetchTopic expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("FetchTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("FetchTopic expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<FetchRequestData.FetchPartition> _collection = new ArrayList<FetchRequestData.FetchPartition>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(FetchPartitionJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(FetchRequestData.FetchTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_version <= 12) {
                _node.set("topic", (JsonNode)new TextNode(_object.topic));
            }
            if (_version >= 13) {
                _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            }
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (FetchRequestData.FetchPartition _element : _object.partitions) {
                _partitionsArray.add(FetchPartitionJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(FetchRequestData.FetchTopic _object, short _version) {
            return FetchTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class FetchPartitionJsonConverter {
        public static FetchRequestData.FetchPartition read(JsonNode _node, short _version) {
            FetchRequestData.FetchPartition _object = new FetchRequestData.FetchPartition();
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            _object.partition = MessageUtil.jsonNodeToInt(_partitionNode, "FetchPartition");
            JsonNode _currentLeaderEpochNode = _node.get("currentLeaderEpoch");
            if (_currentLeaderEpochNode == null) {
                if (_version >= 9) {
                    throw new RuntimeException("FetchPartition: unable to locate field 'currentLeaderEpoch', which is mandatory in version " + _version);
                }
                _object.currentLeaderEpoch = -1;
            } else {
                _object.currentLeaderEpoch = MessageUtil.jsonNodeToInt(_currentLeaderEpochNode, "FetchPartition");
            }
            JsonNode _fetchOffsetNode = _node.get("fetchOffset");
            if (_fetchOffsetNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'fetchOffset', which is mandatory in version " + _version);
            }
            _object.fetchOffset = MessageUtil.jsonNodeToLong(_fetchOffsetNode, "FetchPartition");
            JsonNode _lastFetchedEpochNode = _node.get("lastFetchedEpoch");
            if (_lastFetchedEpochNode == null) {
                if (_version >= 12) {
                    throw new RuntimeException("FetchPartition: unable to locate field 'lastFetchedEpoch', which is mandatory in version " + _version);
                }
                _object.lastFetchedEpoch = -1;
            } else {
                _object.lastFetchedEpoch = MessageUtil.jsonNodeToInt(_lastFetchedEpochNode, "FetchPartition");
            }
            JsonNode _logStartOffsetNode = _node.get("logStartOffset");
            if (_logStartOffsetNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("FetchPartition: unable to locate field 'logStartOffset', which is mandatory in version " + _version);
                }
                _object.logStartOffset = -1L;
            } else {
                _object.logStartOffset = MessageUtil.jsonNodeToLong(_logStartOffsetNode, "FetchPartition");
            }
            JsonNode _partitionMaxBytesNode = _node.get("partitionMaxBytes");
            if (_partitionMaxBytesNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'partitionMaxBytes', which is mandatory in version " + _version);
            }
            _object.partitionMaxBytes = MessageUtil.jsonNodeToInt(_partitionMaxBytesNode, "FetchPartition");
            return _object;
        }

        public static JsonNode write(FetchRequestData.FetchPartition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", (JsonNode)new IntNode(_object.partition));
            if (_version >= 9) {
                _node.set("currentLeaderEpoch", (JsonNode)new IntNode(_object.currentLeaderEpoch));
            }
            _node.set("fetchOffset", (JsonNode)new LongNode(_object.fetchOffset));
            if (_version >= 12) {
                _node.set("lastFetchedEpoch", (JsonNode)new IntNode(_object.lastFetchedEpoch));
            } else if (_object.lastFetchedEpoch != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default lastFetchedEpoch at version " + _version);
            }
            if (_version >= 5) {
                _node.set("logStartOffset", (JsonNode)new LongNode(_object.logStartOffset));
            }
            _node.set("partitionMaxBytes", (JsonNode)new IntNode(_object.partitionMaxBytes));
            return _node;
        }

        public static JsonNode write(FetchRequestData.FetchPartition _object, short _version) {
            return FetchPartitionJsonConverter.write(_object, _version, true);
        }
    }
}

