/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.util;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss"};

    private DateUtil() {
    }

    public static Optional<Long> getTimeStampFromSomeFormats(String date) {
        for (String dateFormat : DATE_FORMATS) {
            try {
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(dateFormat).parseStrict().toFormatter();
                LocalDateTime time = LocalDateTime.parse(date, dateTimeFormatter);
                return Optional.of(time.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            catch (Exception e) {
                log.warn("Error parsing date '{}' with format '{}': {}", new Object[]{date, dateFormat, e.getMessage()});
            }
        }
        log.error("Error parsing date '{}', no corresponding date format", (Object)date);
        return Optional.empty();
    }

    public static Optional<Long> getTimeStampFromFormat(String date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
            return Optional.of(dateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        catch (Exception e) {
            log.error("Error parsing date '{}' with format '{}': {}", new Object[]{date, format, e.getMessage()});
            return Optional.empty();
        }
    }

    public static Long getZonedTimeStampFromFormat(String dateStr, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            return ZonedDateTime.parse(dateStr, formatter).toInstant().toEpochMilli();
        }
        catch (Exception e) {
            log.error("Error parsing date '{}' with format '{}': {}", new Object[]{dateStr, format, e.getMessage()});
            return null;
        }
    }
}

