/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.util.Ensures;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NamedThreadFactory.class);
    private static final AtomicInteger FACTORY_ID = new AtomicInteger(0);
    private final AtomicInteger id = new AtomicInteger(0);
    private final String name;
    private final boolean daemon;
    private final int priority;
    private final ThreadGroup group;

    public NamedThreadFactory(String name) {
        this(name, false, 5);
    }

    public NamedThreadFactory(String name, boolean daemon) {
        this(name, daemon, 5);
    }

    public NamedThreadFactory(String name, int priority) {
        this(name, false, priority);
    }

    public NamedThreadFactory(String name, boolean daemon, int priority) {
        this.name = FACTORY_ID.getAndIncrement() + "# " + name + " #";
        this.daemon = daemon;
        this.priority = priority;
        SecurityManager s = System.getSecurityManager();
        this.group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        Ensures.ensureNonNull(r, "null `runnable`");
        String name2 = this.name + this.id.getAndIncrement();
        Runnable r2 = this.wrapRunnable(r);
        Thread t = this.wrapThread(this.group, r2, name2);
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.info("Creates new {}.", (Object)t);
        return t;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    protected Runnable wrapRunnable(Runnable r) {
        return r;
    }

    protected Thread wrapThread(ThreadGroup group, Runnable r, String name) {
        return new Thread(group, r, name);
    }
}

