/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.service.AccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Generate TOKEN API")
@RestController
@RequestMapping(value={"/api/account/token"}, produces={"application/json"})
public class AuthTokenController {
    private static final Logger log = LoggerFactory.getLogger(AuthTokenController.class);
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/generate"})
    @Operation(summary="Use refresh TOKEN to re-acquire TOKEN", description="Use refresh TOKEN to re-acquire TOKEN")
    public ResponseEntity<Message<Map<String, String>>> generateToken() {
        SubjectSum subjectSum = SurenessContextHolder.getBindSubject();
        if (subjectSum == null) {
            return ResponseEntity.ok(Message.fail((byte)15, "No login user"));
        }
        if (!subjectSum.hasRole("admin")) {
            return ResponseEntity.ok(Message.fail((byte)15, "No permission"));
        }
        try {
            String token = this.accountService.generateToken();
            Map<String, String> rep = Collections.singletonMap("token", token);
            return ResponseEntity.ok(Message.success(rep));
        }
        catch (Exception e) {
            log.error("generate token error", (Throwable)e);
            return ResponseEntity.ok(Message.fail((byte)15, "Generate token error"));
        }
    }
}

