/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Predicate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.dto.CollectorSummary;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.scheduler.AssignJobs;
import org.apache.hertzbeat.manager.scheduler.ConsistentHash;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.manager.service.CollectorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CollectorServiceImpl
implements CollectorService {
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private ConsistentHash consistentHash;
    @Autowired(required=false)
    private ManageServer manageServer;

    @Override
    @Transactional(readOnly=true)
    public Page<CollectorSummary> getCollectors(String name, int pageIndex, Integer pageSize) {
        if (pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
        Specification specification = (root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank(name)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower(root.get("name")), "%" + name.toLowerCase() + "%");
                predicate = criteriaBuilder.and(predicateName);
            }
            return predicate;
        };
        PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
        Page collectors = this.collectorDao.findAll(specification, (Pageable)pageRequest);
        LinkedList<CollectorSummary> collectorSummaryList = new LinkedList<CollectorSummary>();
        for (Collector collector : collectors.getContent()) {
            CollectorSummary.CollectorSummaryBuilder summaryBuilder = CollectorSummary.builder().collector(collector);
            ConsistentHash.Node node = this.consistentHash.getNode(collector.getName());
            if (node != null && node.getAssignJobs() != null) {
                AssignJobs assignJobs = node.getAssignJobs();
                summaryBuilder.pinMonitorNum(assignJobs.getPinnedJobs().size());
                summaryBuilder.dispatchMonitorNum(assignJobs.getJobs().size());
            }
            collectorSummaryList.add(summaryBuilder.build());
        }
        return new PageImpl<CollectorSummary>(collectorSummaryList, pageRequest, collectors.getTotalElements());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRegisteredCollector(List<String> collectors) {
        if (CollectionUtils.isEmpty(collectors)) {
            return;
        }
        collectors.forEach(collector -> {
            List<CollectorMonitorBind> binds = this.collectorMonitorBindDao.findCollectorMonitorBindsByCollector((String)collector);
            if (CollectionUtils.isNotEmpty(binds)) {
                throw new CommonException("The collector " + collector + " has pinned tasks that cannot be deleted.");
            }
        });
        collectors.forEach(collector -> {
            this.manageServer.closeChannel((String)collector);
            this.collectorDao.deleteCollectorByName((String)collector);
        });
    }

    @Override
    public boolean hasCollector(String collector) {
        return this.collectorDao.findCollectorByName(collector).isPresent();
    }

    @Override
    public Map<String, String> generateCollectorDeployInfo(String collector) {
        if (this.hasCollector(collector)) {
            throw new CommonException("There already exists a collector with same name.");
        }
        String host = IpDomainUtil.getLocalhostIp();
        HashMap<String, String> maps = new HashMap<String, String>(6);
        maps.put("identity", collector);
        maps.put("host", host);
        return maps;
    }

    @Override
    public void makeCollectorsOffline(List<String> collectors) {
        if (CollectionUtils.isNotEmpty(collectors)) {
            collectors.forEach(collector -> this.manageServer.getCollectorAndJobScheduler().offlineCollector((String)collector));
        }
    }

    @Override
    public void makeCollectorsOnline(List<String> collectors) {
        if (CollectionUtils.isNotEmpty(collectors)) {
            collectors.forEach(collector -> this.manageServer.getCollectorAndJobScheduler().onlineCollector((String)collector));
        }
    }
}

