/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbstractBulkRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.UploadObjectsProgressListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PutObjectsRequest
extends AbstractBulkRequest {
    private String folderPath;
    private String prefix;
    private List<String> filePaths;
    private TaskCallback<PutObjectResult, PutObjectBasicRequest> callback;
    private long partSize = 0x500000L;
    private long bigfileThreshold = 0x6400000L;
    private int taskNum = 1;
    private UploadObjectsProgressListener listener;
    private long taskProgressInterval = 512000L;
    private long detailProgressInterval = 102400L;
    private Map<ExtensionObjectPermissionEnum, Set<String>> extensionPermissionMap;
    private AccessControlList acl;
    private String successRedirectLocation;
    private SseKmsHeader sseKmsHeader;
    private SseCHeader sseCHeader;

    public PutObjectsRequest(String bucketName, String folderPath) {
        this.bucketName = bucketName;
        this.folderPath = folderPath;
    }

    public PutObjectsRequest(String bucketName, List<String> filePaths) {
        this.bucketName = bucketName;
        this.filePaths = filePaths;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public TaskCallback<PutObjectResult, PutObjectBasicRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<PutObjectResult, PutObjectBasicRequest> callback) {
        this.callback = callback;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public long getBigfileThreshold() {
        return this.bigfileThreshold;
    }

    public void setBigfileThreshold(long bigfileThreshold) {
        this.bigfileThreshold = bigfileThreshold < 102400L ? 102400L : Math.min(bigfileThreshold, 0x140000000L);
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum < 1 ? 1 : Math.min(taskNum, 1000);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (null == prefix) {
            return;
        }
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public UploadObjectsProgressListener getUploadObjectsProgressListener() {
        return this.listener;
    }

    public void setUploadObjectsProgressListener(UploadObjectsProgressListener listener) {
        this.listener = listener;
    }

    public long getTaskProgressInterval() {
        return this.taskProgressInterval;
    }

    public void setTaskProgressInterval(long taskProgressInterval) {
        this.taskProgressInterval = Math.max(taskProgressInterval, this.detailProgressInterval);
    }

    public long getDetailProgressInterval() {
        return this.detailProgressInterval;
    }

    public void setDetailProgressInterval(long detailProgressInterval) {
        this.detailProgressInterval = detailProgressInterval;
    }

    public SseKmsHeader getSseKmsHeader() {
        return this.sseKmsHeader;
    }

    public void setSseKmsHeader(SseKmsHeader sseKmsHeader) {
        this.sseKmsHeader = sseKmsHeader;
    }

    public SseCHeader getSseCHeader() {
        return this.sseCHeader;
    }

    public void setSseCHeader(SseCHeader sseCHeader) {
        this.sseCHeader = sseCHeader;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getSuccessRedirectLocation() {
        return this.successRedirectLocation;
    }

    public void setSuccessRedirectLocation(String successRedirectLocation) {
        this.successRedirectLocation = successRedirectLocation;
    }

    public void grantExtensionPermission(String domainId, ExtensionObjectPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        Set users = this.getExtensionPermissionMap().computeIfAbsent(extensionPermissionEnum, k -> new HashSet());
        users.add(domainId.trim());
    }

    public void withdrawExtensionPermission(String domainId, ExtensionObjectPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        domainId = domainId.trim();
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds != null) {
            domainIds.remove(domainId);
        }
    }

    public void withdrawExtensionPermissions(String domainId) {
        if (ServiceUtils.isValid(domainId)) {
            for (Map.Entry<ExtensionObjectPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId.trim())) continue;
                entry.getValue().remove(domainId);
            }
        }
    }

    public Set<ExtensionObjectPermissionEnum> getAllGrantPermissions() {
        return this.getExtensionPermissionMap().keySet();
    }

    public Set<String> getDomainIdsByGrantPermission(ExtensionObjectPermissionEnum extensionPermissionEnum) {
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds == null) {
            domainIds = new HashSet<String>();
        }
        return domainIds;
    }

    public Set<ExtensionObjectPermissionEnum> getGrantPermissionsByDomainId(String domainId) {
        HashSet<ExtensionObjectPermissionEnum> grantPermissions = new HashSet<ExtensionObjectPermissionEnum>();
        if (ServiceUtils.isValid(domainId)) {
            domainId = domainId.trim();
            for (Map.Entry<ExtensionObjectPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId)) continue;
                grantPermissions.add(entry.getKey());
            }
        }
        return grantPermissions;
    }

    public Map<ExtensionObjectPermissionEnum, Set<String>> getExtensionPermissionMap() {
        if (this.extensionPermissionMap == null) {
            this.extensionPermissionMap = new HashMap<ExtensionObjectPermissionEnum, Set<String>>();
        }
        return this.extensionPermissionMap;
    }

    public void setExtensionPermissionMap(Map<ExtensionObjectPermissionEnum, Set<String>> extensionPermissionMap) {
        if (extensionPermissionMap == null) {
            return;
        }
        this.extensionPermissionMap = extensionPermissionMap;
    }

    @Override
    public String toString() {
        return "PutObjectsRequest [folderPath=" + this.folderPath + ", prefix=" + this.prefix + ", filePaths=" + this.filePaths + ", callback=" + this.callback + ", partSize=" + this.partSize + ", bigfileThreshold=" + this.bigfileThreshold + ", taskNum=" + this.taskNum + ", listener=" + this.listener + ", taskProgressInterval=" + this.taskProgressInterval + ", detailProgressInterval=" + this.detailProgressInterval + ", extensionPermissionMap=" + this.extensionPermissionMap + ", acl=" + this.acl + ", getBucketName()=" + this.getBucketName() + ", isRequesterPays()=" + this.isRequesterPays() + "]";
    }
}

