/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

@FunctionalInterface
public interface CapacityPolicy {
    public static CapacityPolicy fixedCapacity(int capacity) {
        return new FixedCapacity(capacity);
    }

    public static CapacityPolicy linearDynamicCapacity(int initialSize, int maxSize, int variation) {
        return new LinearDynamicCapacity(initialSize, maxSize, variation);
    }

    public boolean ensureCapacity(int var1);

    public static class FixedCapacity
    implements CapacityPolicy {
        private final int capacity;

        protected FixedCapacity(int capacity) {
            this.capacity = capacity < 1 ? 0 : capacity;
        }

        @Override
        public boolean ensureCapacity(int current) {
            return this.capacity < 1 || current < this.capacity;
        }
    }

    public static class LinearDynamicCapacity
    implements CapacityPolicy {
        private volatile int capacity;
        private volatile int count;
        private final int maxSize;
        private final int variation;

        protected LinearDynamicCapacity(int initialSize, int maxSize, int variation) {
            this.capacity = initialSize < 1 ? 1 : initialSize;
            this.count = 0;
            this.maxSize = maxSize < 1 ? Integer.MAX_VALUE : Math.max(maxSize, initialSize);
            this.variation = variation < 1 ? 100 : variation;
        }

        @Override
        public boolean ensureCapacity(int current) {
            if (current < this.capacity) {
                this.count = 0;
                return true;
            }
            if (this.capacity < this.maxSize && ++this.count >= this.variation) {
                this.count = 0;
                ++this.capacity;
                return true;
            }
            return false;
        }
    }
}

