/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.warehouse;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;

@Entity
@Table(name="hzb_history", indexes={@Index(name="history_query_index", columnList="monitorId"), @Index(name="history_query_index", columnList="app"), @Index(name="history_query_index", columnList="metrics"), @Index(name="history_query_index", columnList="metric")})
@Schema(description="Metrics History Data Entity")
public class History {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(description="Metric data history entity primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Monitoring Id", example="87432674336", accessMode=Schema.AccessMode.READ_WRITE)
    private Long monitorId;
    @Schema(title="Monitoring Type mysql oracle db2")
    private String app;
    @Schema(title="Monitoring Metrics innodb disk cpu")
    private String metrics;
    @Schema(title="Monitoring Metric usage speed count")
    private String metric;
    @Column(length=5000)
    private String instance;
    @Schema(title="Metric Type 0: Number 1\uff1aString")
    private Byte metricType;
    @Schema(title="Metric String Value")
    @Column(length=2048)
    private String str;
    @Schema(title="Metric Integer Value")
    private Integer int32;
    @Schema(title="Metric Number Value")
    private Double dou;
    @Schema(title="Collect Time")
    private Long time;

    public static HistoryBuilder builder() {
        return new HistoryBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public String getApp() {
        return this.app;
    }

    public String getMetrics() {
        return this.metrics;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getInstance() {
        return this.instance;
    }

    public Byte getMetricType() {
        return this.metricType;
    }

    public String getStr() {
        return this.str;
    }

    public Integer getInt32() {
        return this.int32;
    }

    public Double getDou() {
        return this.dou;
    }

    public Long getTime() {
        return this.time;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setMetricType(Byte metricType) {
        this.metricType = metricType;
    }

    public void setStr(String str) {
        this.str = str;
    }

    public void setInt32(Integer int32) {
        this.int32 = int32;
    }

    public void setDou(Double dou) {
        this.dou = dou;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof History)) {
            return false;
        }
        History other = (History)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        Byte this$metricType = this.getMetricType();
        Byte other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !((Object)this$metricType).equals(other$metricType)) {
            return false;
        }
        Integer this$int32 = this.getInt32();
        Integer other$int32 = other.getInt32();
        if (this$int32 == null ? other$int32 != null : !((Object)this$int32).equals(other$int32)) {
            return false;
        }
        Double this$dou = this.getDou();
        Double other$dou = other.getDou();
        if (this$dou == null ? other$dou != null : !((Object)this$dou).equals(other$dou)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$metrics = this.getMetrics();
        String other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        String this$metric = this.getMetric();
        String other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        String this$str = this.getStr();
        String other$str = other.getStr();
        return !(this$str == null ? other$str != null : !this$str.equals(other$str));
    }

    protected boolean canEqual(Object other) {
        return other instanceof History;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        Byte $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : ((Object)$metricType).hashCode());
        Integer $int32 = this.getInt32();
        result = result * 59 + ($int32 == null ? 43 : ((Object)$int32).hashCode());
        Double $dou = this.getDou();
        result = result * 59 + ($dou == null ? 43 : ((Object)$dou).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        String $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        String $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        String $str = this.getStr();
        result = result * 59 + ($str == null ? 43 : $str.hashCode());
        return result;
    }

    public String toString() {
        return "History(id=" + this.getId() + ", monitorId=" + this.getMonitorId() + ", app=" + this.getApp() + ", metrics=" + this.getMetrics() + ", metric=" + this.getMetric() + ", instance=" + this.getInstance() + ", metricType=" + this.getMetricType() + ", str=" + this.getStr() + ", int32=" + this.getInt32() + ", dou=" + this.getDou() + ", time=" + this.getTime() + ")";
    }

    public History(Long id, Long monitorId, String app, String metrics, String metric, String instance, Byte metricType, String str, Integer int32, Double dou, Long time) {
        this.id = id;
        this.monitorId = monitorId;
        this.app = app;
        this.metrics = metrics;
        this.metric = metric;
        this.instance = instance;
        this.metricType = metricType;
        this.str = str;
        this.int32 = int32;
        this.dou = dou;
        this.time = time;
    }

    public History() {
    }

    public static class HistoryBuilder {
        private Long id;
        private Long monitorId;
        private String app;
        private String metrics;
        private String metric;
        private String instance;
        private Byte metricType;
        private String str;
        private Integer int32;
        private Double dou;
        private Long time;

        HistoryBuilder() {
        }

        public HistoryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public HistoryBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public HistoryBuilder app(String app) {
            this.app = app;
            return this;
        }

        public HistoryBuilder metrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public HistoryBuilder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public HistoryBuilder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public HistoryBuilder metricType(Byte metricType) {
            this.metricType = metricType;
            return this;
        }

        public HistoryBuilder str(String str) {
            this.str = str;
            return this;
        }

        public HistoryBuilder int32(Integer int32) {
            this.int32 = int32;
            return this;
        }

        public HistoryBuilder dou(Double dou) {
            this.dou = dou;
            return this;
        }

        public HistoryBuilder time(Long time) {
            this.time = time;
            return this;
        }

        public History build() {
            return new History(this.id, this.monitorId, this.app, this.metrics, this.metric, this.instance, this.metricType, this.str, this.int32, this.dou, this.time);
        }

        public String toString() {
            return "History.HistoryBuilder(id=" + this.id + ", monitorId=" + this.monitorId + ", app=" + this.app + ", metrics=" + this.metrics + ", metric=" + this.metric + ", instance=" + this.instance + ", metricType=" + this.metricType + ", str=" + this.str + ", int32=" + this.int32 + ", dou=" + this.dou + ", time=" + this.time + ")";
        }
    }
}

