/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.agent.service.impl;

import org.apache.hertzbeat.ai.agent.pojo.dto.ChatRequestContext;
import org.apache.hertzbeat.ai.agent.service.ChatClientProviderService;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ChatClientProviderServiceImpl
implements ChatClientProviderService {
    private final ChatClient chatClient;
    @Qualifier(value="hertzbeatTools")
    @Autowired
    private ToolCallbackProvider toolCallbackProvider;

    @Autowired
    public ChatClientProviderServiceImpl(@Qualifier(value="openAiChatClient") ChatClient openAiChatClient) {
        this.chatClient = openAiChatClient;
    }

    @Override
    public String complete(String message) {
        return this.chatClient.prompt().user(message).call().content();
    }

    @Override
    public String streamChat(ChatRequestContext context) {
        try {
            return this.chatClient.prompt("You are an AI assistant specialized in monitoring infrastructure and applications with HertzBeat.\nYour role is to help users manage and analyze their monitoring data using the available tools.\nYou have access to the following HertzBeat monitoring tools:\n- list_monitors: Query monitor information with flexible filtering and pagination\n- add_monitor: Add a new monitor to the system\nWhen users ask questions about their monitoring setup or data, identify which tool would be most helpful\nand use it to provide relevant information. Always provide clear explanations of the monitoring data and\nsuggest next steps or insights based on the results.\nFor monitoring-related queries:\n1. If users want to see their monitors, use list_monitors with appropriate filters\n2. If users want to add a new monitor, use add_monitor with the necessary details\n3. If the monitoring information shows potential issues, highlight them and suggest troubleshooting steps\nFor parameters that accept specific values:\n- Monitor status values: 0 (no monitor), 1 (usable), 2 (disabled), 9 (all)\n- Sort fields typically include: name, host, app, gmtCreate\n- Sort order should be 'asc' or 'desc'\nKeep responses focused on monitoring topics and HertzBeat capabilities.\nIf you're unsure about specific monitoring details, ask clarifying questions before using the tools.\n").user(context.getMessage()).toolCallbacks(new ToolCallbackProvider[]{this.toolCallbackProvider}).call().content();
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }
}

