/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.filter.BatchFilter;
import org.apache.orc.filter.PluginFilterService;
import org.apache.orc.impl.filter.AndFilter;
import org.apache.orc.impl.filter.BatchFilterFactory;
import org.apache.orc.impl.filter.OrFilter;
import org.apache.orc.impl.filter.VectorFilter;
import org.apache.orc.impl.filter.leaf.LeafFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FilterFactory.class);

    public static BatchFilter createBatchFilter(Reader.Options opts, TypeDescription readSchema, boolean isSchemaCaseAware, OrcFile.Version version, boolean normalize, String filePath, Configuration conf) {
        ArrayList<BatchFilter> filters = new ArrayList<BatchFilter>(2);
        if (opts.getFilterCallback() != null) {
            filters.add(BatchFilterFactory.create(opts.getFilterCallback(), opts.getPreFilterColumnNames()));
        }
        if (opts.allowPluginFilters()) {
            List<BatchFilter> pluginFilters = FilterFactory.findPluginFilters(filePath, conf);
            if (!(pluginFilters = FilterFactory.getAllowedFilters(pluginFilters, opts.pluginAllowListFilters())).isEmpty()) {
                LOG.debug("Added plugin filters {} to the read", pluginFilters);
                filters.addAll(pluginFilters);
            }
        }
        if (opts.isAllowSARGToFilter() && opts.getSearchArgument() != null) {
            SearchArgument sArg = opts.getSearchArgument();
            HashSet<String> colNames = new HashSet<String>();
            try {
                ExpressionTree exprTree = normalize ? sArg.getExpression() : sArg.getCompactExpression();
                LOG.debug("normalize={}, using expressionTree={}", (Object)normalize, (Object)exprTree);
                filters.add(BatchFilterFactory.create(FilterFactory.createSArgFilter(exprTree, colNames, sArg.getLeaves(), readSchema, isSchemaCaseAware, version), colNames.toArray(new String[0])));
            }
            catch (UnSupportedSArgException e) {
                LOG.warn("SArg: {} is not supported\n{}", (Object)sArg, (Object)e.getMessage());
            }
        }
        return BatchFilterFactory.create(filters);
    }

    public static VectorFilter createSArgFilter(ExpressionTree expr, Set<String> colIds, List<PredicateLeaf> leaves, TypeDescription readSchema, boolean isSchemaCaseAware, OrcFile.Version version) throws UnSupportedSArgException {
        return switch (expr.getOperator()) {
            case ExpressionTree.Operator.OR -> {
                VectorFilter[] orFilters = new VectorFilter[expr.getChildren().size()];
                for (int i = 0; i < expr.getChildren().size(); ++i) {
                    orFilters[i] = FilterFactory.createSArgFilter((ExpressionTree)expr.getChildren().get(i), colIds, leaves, readSchema, isSchemaCaseAware, version);
                }
                yield new OrFilter(orFilters);
            }
            case ExpressionTree.Operator.AND -> {
                VectorFilter[] andFilters = new VectorFilter[expr.getChildren().size()];
                for (int i = 0; i < expr.getChildren().size(); ++i) {
                    andFilters[i] = FilterFactory.createSArgFilter((ExpressionTree)expr.getChildren().get(i), colIds, leaves, readSchema, isSchemaCaseAware, version);
                }
                yield new AndFilter(andFilters);
            }
            case ExpressionTree.Operator.NOT -> {
                ExpressionTree leaf = (ExpressionTree)expr.getChildren().get(0);
                if (!$assertionsDisabled && leaf.getOperator() != ExpressionTree.Operator.LEAF) {
                    throw new AssertionError();
                }
                yield LeafFilterFactory.createLeafVectorFilter(leaves.get(leaf.getLeaf()), colIds, readSchema, isSchemaCaseAware, version, true);
            }
            case ExpressionTree.Operator.LEAF -> LeafFilterFactory.createLeafVectorFilter(leaves.get(expr.getLeaf()), colIds, readSchema, isSchemaCaseAware, version, false);
            default -> throw new UnSupportedSArgException(String.format("SArg expression: %s is not supported", expr));
        };
    }

    static List<BatchFilter> findPluginFilters(String filePath, Configuration conf) {
        ArrayList<BatchFilter> filters = new ArrayList<BatchFilter>();
        for (PluginFilterService s : ServiceLoader.load(PluginFilterService.class)) {
            LOG.debug("Processing filter service {}", (Object)s);
            BatchFilter filter = s.getFilter(filePath, conf);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters;
    }

    private static List<BatchFilter> getAllowedFilters(List<BatchFilter> filters, List<String> allowList) {
        ArrayList<BatchFilter> allowBatchFilters = new ArrayList<BatchFilter>();
        if (allowList != null && allowList.contains("*")) {
            return filters;
        }
        if (allowList == null || allowList.isEmpty() || filters == null) {
            LOG.debug("Disable all PluginFilter.");
            return allowBatchFilters;
        }
        for (BatchFilter filter : filters) {
            if (allowList.contains(filter.getClass().getName())) {
                allowBatchFilters.add(filter);
                continue;
            }
            LOG.debug("Ignoring filter service {}", (Object)filter);
        }
        return allowBatchFilters;
    }

    public static class UnSupportedSArgException
    extends Exception {
        public UnSupportedSArgException(String message) {
            super(message);
        }
    }
}

