/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.abort.compaction;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortCompactionResponseElement;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.process.abort.compaction.AbortCompactionsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AbortCompactionsOperation
extends DDLOperation<AbortCompactionsDesc> {
    public AbortCompactionsOperation(DDLOperationContext context, AbortCompactionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        AbortCompactionRequest request = new AbortCompactionRequest();
        request.setCompactionIds(((AbortCompactionsDesc)this.desc).getCompactionIds());
        AbortCompactResponse response = this.context.getDb().abortCompactions(request);
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((AbortCompactionsDesc)this.desc).getResFile()), this.context);){
            this.writeHeader(os);
            if (response.getAbortedcompacts() != null) {
                for (AbortCompactionResponseElement e : response.getAbortedcompacts().values()) {
                    this.writeRow(os, e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("abort compactions: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        os.writeBytes("CompactionId");
        os.write(9);
        os.writeBytes("Status");
        os.write(9);
        os.writeBytes("Message");
        os.write(10);
    }

    private void writeRow(DataOutputStream os, AbortCompactionResponseElement e) throws IOException {
        os.writeBytes(Long.toString(e.getCompactionId()));
        os.write(9);
        os.writeBytes(e.getStatus());
        os.write(9);
        os.writeBytes(e.getMessage());
        os.write(10);
    }
}

