/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprCondExprNull
extends IfExprCondExprBase {
    private static final long serialVersionUID = 1L;

    public IfExprCondExprNull(int arg1Column, int arg2Column, int outputColumnNum) {
        super(arg1Column, arg2Column, outputColumnNum);
    }

    public IfExprCondExprNull() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int i;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        super.evaluate(batch);
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        outputColVector.init();
        ColumnVector thenColVector = batch.cols[this.inputColumnNum[1]];
        int thenCount = this.thenSelectedCount;
        int elseCount = this.elseSelectedCount;
        if (this.isIfStatementResultRepeated) {
            if (this.isIfStatementResultThen) {
                this.childExpressions[1].evaluate(batch);
                thenColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
            }
            return;
        }
        this.conditionalEvaluate(batch, this.childExpressions[1], this.thenSelected, thenCount);
        for (i = 0; i < thenCount; ++i) {
            int batchIndex = this.thenSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, thenColVector);
        }
        outputColVector.noNulls = false;
        for (i = 0; i < elseCount; ++i) {
            outputColVector.isNull[this.elseSelected[i]] = true;
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]) + ", null";
    }
}

