/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprNullCondExpr
extends IfExprCondExprBase {
    private static final long serialVersionUID = 1L;

    public IfExprNullCondExpr(int arg1Column, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg3Column, outputColumnNum);
    }

    public IfExprNullCondExpr() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int i;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        super.evaluate(batch);
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        outputColVector.init();
        ColumnVector elseColVector = batch.cols[this.inputColumnNum[1]];
        int thenCount = this.thenSelectedCount;
        int elseCount = this.elseSelectedCount;
        if (this.isIfStatementResultRepeated) {
            if (this.isIfStatementResultThen) {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
            } else {
                this.childExpressions[1].evaluate(batch);
                elseColVector.copySelected(batch.selectedInUse, batch.selected, n, outputColVector);
            }
            return;
        }
        outputColVector.noNulls = false;
        for (i = 0; i < thenCount; ++i) {
            outputColVector.isNull[this.thenSelected[i]] = true;
        }
        this.conditionalEvaluate(batch, this.childExpressions[1], this.elseSelected, elseCount);
        for (i = 0; i < elseCount; ++i) {
            int batchIndex = this.elseSelected[i];
            outputIsNull[batchIndex] = false;
            outputColVector.setElement(batchIndex, batchIndex, elseColVector);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", null, " + this.getColumnParamString(2, this.inputColumnNum[1]);
    }
}

