/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncFloat;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class TruncDecimal
extends TruncFloat {
    private static final long serialVersionUID = 1L;

    public TruncDecimal() {
    }

    public TruncDecimal(int colNum, int scale, int outputColumnNum) {
        super(colNum, scale, outputColumnNum);
    }

    @Override
    protected void trunc(ColumnVector inputColVector, ColumnVector outputColVector, int i) {
        HiveDecimal input = ((DecimalColumnVector)inputColVector).vector[i].getHiveDecimal();
        HiveDecimal output = this.trunc(input);
        ((DecimalColumnVector)outputColVector).vector[i] = new HiveDecimalWritable(output);
    }

    protected HiveDecimal trunc(HiveDecimal input) {
        HiveDecimal pow = HiveDecimal.create((double)Math.pow(10.0, Math.abs(this.scale)));
        if (this.scale >= 0) {
            if (this.scale != 0) {
                long longValue = input.multiply(pow).longValue();
                return HiveDecimal.create((long)longValue).divide(pow);
            }
            return HiveDecimal.create((long)input.longValue());
        }
        long longValue2 = input.divide(pow).longValue();
        return HiveDecimal.create((long)longValue2).multiply(pow);
    }

    @Override
    protected VectorExpressionDescriptor.ArgumentType getInputColumnType() {
        return VectorExpressionDescriptor.ArgumentType.DECIMAL;
    }
}

