/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SchemaInference;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Writable;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "orc.compress"})
public class OrcSerde
extends AbstractSerDe
implements SchemaInference {
    private static final Logger LOG = LoggerFactory.getLogger(OrcSerde.class);
    private final OrcSerdeRow row = new OrcSerdeRow();
    private ObjectInspector inspector = null;
    static final String COMPRESSION = "orc.compress";
    static final Pattern UNQUOTED_NAMES = Pattern.compile("^[a-zA-Z0-9_]+$");

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        StructTypeInfo rootType = new StructTypeInfo();
        rootType.setAllStructFieldNames(this.getColumnNames());
        rootType.setAllStructFieldTypeInfos(this.getColumnTypes());
        this.inspector = OrcStruct.createObjectInspector((TypeInfo)rootType);
    }

    protected List<TypeInfo> parseColumnTypes() {
        List fieldTypes = super.parseColumnTypes();
        if (fieldTypes.isEmpty()) {
            return Collections.nCopies(this.getColumnNames().size(), TypeInfoFactory.stringTypeInfo);
        }
        return fieldTypes;
    }

    public Class<? extends Writable> getSerializedClass() {
        return OrcSerdeRow.class;
    }

    public Writable serialize(Object realRow, ObjectInspector inspector) {
        this.row.realRow = realRow;
        this.row.inspector = inspector;
        return this.row;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        return writable;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public List<FieldSchema> readSchema(Configuration conf, String file) throws SerDeException {
        List fieldTypes;
        List fieldNames;
        try (Reader reader = OrcFile.createReader((Path)new Path(file), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));){
            fieldNames = reader.getSchema().getFieldNames();
            fieldTypes = reader.getSchema().getChildren();
        }
        catch (Exception e) {
            throw new SerDeException(ErrorMsg.ORC_FOOTER_ERROR.getErrorCodedMsg(), (Throwable)e);
        }
        ArrayList<FieldSchema> schema = new ArrayList<FieldSchema>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            FieldSchema fieldSchema = this.convertOrcTypeToFieldSchema((String)fieldNames.get(i), (TypeDescription)fieldTypes.get(i));
            schema.add(fieldSchema);
            LOG.debug("Inferred field schema {}", (Object)fieldSchema);
        }
        return schema;
    }

    private FieldSchema convertOrcTypeToFieldSchema(String fieldName, TypeDescription fieldType) {
        String typeName = this.convertOrcTypeToFieldType(fieldType);
        return new FieldSchema(fieldName, typeName, "Inferred from Orc file.");
    }

    private String convertOrcTypeToFieldType(TypeDescription fieldType) {
        if (fieldType.getCategory().isPrimitive()) {
            return this.convertPrimitiveType(fieldType);
        }
        return this.convertComplexType(fieldType);
    }

    private String convertPrimitiveType(TypeDescription fieldType) {
        if (fieldType.getCategory().getName().equals("timestamp with local time zone")) {
            throw new IllegalArgumentException("Unhandled ORC type " + fieldType.getCategory().getName());
        }
        return fieldType.toString();
    }

    private String convertComplexType(TypeDescription fieldType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(fieldType.getCategory().getName());
        switch (fieldType.getCategory()) {
            case LIST: 
            case MAP: 
            case UNION: {
                buffer.append('<');
                for (int i = 0; i < fieldType.getChildren().size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    buffer.append(this.convertOrcTypeToFieldType((TypeDescription)fieldType.getChildren().get(i)));
                }
                buffer.append('>');
                break;
            }
            case STRUCT: {
                buffer.append('<');
                for (int i = 0; i < fieldType.getChildren().size(); ++i) {
                    if (i != 0) {
                        buffer.append(',');
                    }
                    OrcSerde.getStructFieldName(buffer, (String)fieldType.getFieldNames().get(i));
                    buffer.append(':');
                    buffer.append(this.convertOrcTypeToFieldType((TypeDescription)fieldType.getChildren().get(i)));
                }
                buffer.append('>');
                break;
            }
            default: {
                throw new IllegalArgumentException("ORC doesn't handle " + fieldType.getCategory());
            }
        }
        return buffer.toString();
    }

    static void getStructFieldName(StringBuilder buffer, String name) {
        if (UNQUOTED_NAMES.matcher(name).matches()) {
            buffer.append(name);
        } else {
            buffer.append('`').append(name.replace("`", "``")).append('`');
        }
    }

    final class OrcSerdeRow
    implements Writable {
        Object realRow;
        ObjectInspector inspector;

        OrcSerdeRow() {
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("can't write the bundle");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("can't read the bundle");
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        Object getRow() {
            return this.realRow;
        }
    }
}

