/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.optimizer.calcite.RangeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SearchTransformer<C extends Comparable<C>> {
    private final RexBuilder rexBuilder;
    private final RexNode ref;
    private final Sarg<C> sarg;
    protected final RelDataType type;

    public SearchTransformer(RexBuilder rexBuilder, RexCall search) {
        this.rexBuilder = rexBuilder;
        this.ref = (RexNode)search.getOperands().get(0);
        RexLiteral literal = (RexLiteral)search.operands.get(1);
        this.sarg = Objects.requireNonNull((Sarg)literal.getValueAs(Sarg.class), "Sarg");
        this.type = literal.getType();
    }

    public RexNode transform() {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.getClass().getName(), "transformSearch");
        RangeConverter consumer = new RangeConverter(this.rexBuilder, this.type, this.ref);
        RangeSets.forEach((RangeSet)this.sarg.rangeSet, consumer);
        ArrayList<RexNode> orList = new ArrayList<RexNode>();
        if (this.sarg.nullAs == RexUnknownAs.TRUE) {
            orList.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.ref}));
        }
        switch (consumer.inLiterals.size()) {
            case 0: {
                break;
            }
            case 1: {
                orList.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.ref, consumer.inLiterals.get(0)}));
                break;
            }
            default: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>(consumer.inLiterals.size() + 1);
                operands.add(this.ref);
                operands.addAll(consumer.inLiterals);
                orList.add(this.rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, operands));
            }
        }
        orList.addAll(consumer.nodes);
        RexNode x = RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, orList);
        if (this.sarg.nullAs == RexUnknownAs.FALSE) {
            RexNode notNull = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{this.ref});
            x = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, Arrays.asList(notNull, x));
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "transformSearch");
        return x;
    }

    public static class Shuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public Shuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            boolean[] update = new boolean[]{false};
            switch (call.getKind()) {
                case OR: {
                    List clonedOperands = this.visitList((List)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, (Iterable)clonedOperands);
                    }
                    return call;
                }
                case AND: {
                    List clonedOperands = this.visitList((List)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeConjunction((RexBuilder)this.rexBuilder, (Iterable)clonedOperands);
                    }
                    return call;
                }
                case SEARCH: {
                    return new SearchTransformer(this.rexBuilder, call).transform();
                }
            }
            return super.visitCall(call);
        }
    }
}

