/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.util.ControlFlowException;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewIncrementalRewritingRelVisitor;

public class MaterializedViewRewritingRelVisitor
extends RelVisitor {
    private boolean containsAggregate = false;
    private final boolean fullAcidView;
    private IncrementalRebuildMode incrementalRebuildMode;
    private int countIndex;

    public MaterializedViewRewritingRelVisitor(boolean fullAcidView) {
        this.fullAcidView = fullAcidView;
        this.incrementalRebuildMode = IncrementalRebuildMode.NOT_AVAILABLE;
        this.countIndex = -1;
    }

    public void visit(RelNode node, int ordinal, RelNode parent) {
        if (node instanceof Aggregate) {
            this.containsAggregate = true;
            RelNode input = node.getInput(0);
            if (input instanceof Union) {
                this.check((Union)input);
            }
        } else if (node instanceof Union) {
            this.check((Union)node);
        } else if (node instanceof Project) {
            super.visit(node, ordinal, parent);
        }
        throw new ReturnedValue(IncrementalRebuildMode.NOT_AVAILABLE);
    }

    private void check(Union union) {
        if (union.getInputs().size() != 2) {
            throw new ReturnedValue(IncrementalRebuildMode.NOT_AVAILABLE);
        }
        RelNode queryBranch = union.getInput(0);
        MaterializedViewIncrementalRewritingRelVisitor.Result result = new MaterializedViewIncrementalRewritingRelVisitor().go(queryBranch);
        this.incrementalRebuildMode = result.getIncrementalRebuildMode();
        this.containsAggregate = result.containsAggregate();
        this.countIndex = result.getCountStarIndex();
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    RelOptHiveTable hiveTable = (RelOptHiveTable)node.getTable();
                    if (!hiveTable.getHiveTableMD().isMaterializedView()) {
                        throw new ReturnedValue(IncrementalRebuildMode.NOT_AVAILABLE);
                    }
                    if (MaterializedViewRewritingRelVisitor.this.containsAggregate && !MaterializedViewRewritingRelVisitor.this.fullAcidView) {
                        throw new ReturnedValue(IncrementalRebuildMode.NOT_AVAILABLE);
                    }
                } else if (node instanceof Project) {
                    super.visit(node, ordinal, parent);
                } else {
                    throw new ReturnedValue(IncrementalRebuildMode.NOT_AVAILABLE);
                }
            }
        }.go(union.getInput(1));
        throw new ReturnedValue(result.getIncrementalRebuildMode());
    }

    public RelNode go(RelNode p) {
        try {
            this.visit(p, 0, null);
        }
        catch (ReturnedValue e) {
            this.incrementalRebuildMode = e.incrementalRebuildMode;
        }
        return p;
    }

    public boolean isContainsAggregate() {
        return this.containsAggregate;
    }

    public IncrementalRebuildMode getIncrementalRebuildMode() {
        return this.incrementalRebuildMode;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    private static final class ReturnedValue
    extends ControlFlowException {
        private final IncrementalRebuildMode incrementalRebuildMode;

        public ReturnedValue(IncrementalRebuildMode incrementalRebuildMode) {
            this.incrementalRebuildMode = incrementalRebuildMode;
        }
    }
}

