/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.MapWork;

public abstract class AbstractJoinTaskDispatcher
implements SemanticDispatcher {
    protected final PhysicalContext physicalContext;

    public AbstractJoinTaskDispatcher(PhysicalContext context) {
        this.physicalContext = context;
    }

    public abstract Task<?> processCurrentTask(MapRedTask var1, ConditionalTask var2, Context var3) throws SemanticException;

    protected void replaceTaskWithConditionalTask(Task<?> currTask, ConditionalTask cndTsk) {
        List<Task<?>> parentTasks = currTask.getParentTasks();
        currTask.setParentTasks(null);
        if (parentTasks != null) {
            for (Task<ConditionalWork> task : parentTasks) {
                task.addDependentTask(cndTsk);
                task.removeDependentTask(currTask);
            }
        } else {
            this.physicalContext.removeFromRootTask(currTask);
            this.physicalContext.addToRootTask(cndTsk);
        }
        List<Task<?>> oldChildTasks = currTask.getChildTasks();
        if (oldChildTasks != null) {
            for (Task<?> tsk : cndTsk.getListTasks()) {
                if (tsk.equals(currTask)) continue;
                for (Task<?> oldChild : oldChildTasks) {
                    tsk.addDependentTask(oldChild);
                }
            }
        }
    }

    protected void replaceTask(Task<?> currTask, Task<?> newTask) {
        List<Task<?>> parentTasks = currTask.getParentTasks();
        currTask.setParentTasks(null);
        if (parentTasks != null) {
            for (Task<?> tsk : parentTasks) {
                tsk.removeDependentTask(currTask);
                tsk.addDependentTask(newTask);
            }
        } else {
            this.physicalContext.removeFromRootTask(currTask);
            this.physicalContext.addToRootTask(newTask);
        }
        List<Task<?>> oldChildTasks = currTask.getChildTasks();
        currTask.setChildTasks(null);
        if (oldChildTasks != null) {
            for (Task<?> tsk : oldChildTasks) {
                tsk.getParentTasks().remove(currTask);
                newTask.addDependentTask(tsk);
            }
        }
    }

    public long getTotalKnownInputSize(Context context, MapWork currWork, Map<Path, List<String>> pathToAliases, Map<String, Long> aliasToSize) throws SemanticException {
        try {
            Utilities.getInputSummary(context, currWork, null).getLength();
            long aliasTotalKnownInputSize = 0L;
            for (Map.Entry<Path, List<String>> entry : pathToAliases.entrySet()) {
                Path path = entry.getKey();
                List<String> aliasList = entry.getValue();
                ContentSummary cs = context.getCS(path);
                if (cs == null) continue;
                long size = cs.getLength();
                for (String alias : aliasList) {
                    aliasTotalKnownInputSize += size;
                    Long es = aliasToSize.get(alias);
                    if (es == null) {
                        es = 0L;
                    }
                    es = es + size;
                    aliasToSize.put(alias, es);
                }
            }
            return aliasTotalKnownInputSize;
        }
        catch (Exception e) {
            throw new SemanticException("Generate Map Join Task Error: ", (Throwable)e);
        }
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        if (nodeOutputs == null || nodeOutputs.length == 0) {
            throw new SemanticException("No Dispatch Context");
        }
        TaskGraphWalker.TaskGraphWalkerContext walkerCtx = (TaskGraphWalker.TaskGraphWalkerContext)nodeOutputs[0];
        Task currTask = (Task)nd;
        if (currTask.isMapRedTask()) {
            if (currTask instanceof ConditionalTask) {
                List<Task<?>> taskList = ((ConditionalTask)currTask).getListTasks();
                for (Task<?> tsk : taskList) {
                    if (!tsk.isMapRedTask()) continue;
                    Task<?> newTask = this.processCurrentTask((MapRedTask)tsk, (ConditionalTask)currTask, this.physicalContext.getContext());
                    walkerCtx.addToDispatchList(newTask);
                }
            } else {
                Task<?> newTask = this.processCurrentTask((MapRedTask)currTask, null, this.physicalContext.getContext());
                walkerCtx.addToDispatchList(newTask);
            }
        }
        return null;
    }
}

