/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryAccessor;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_MinZ", value="_FUNC_(geometry) - returns the minimum Z coordinate of geometry", extended="Example:\n  SELECT _FUNC_(ST_PointZ(1.5, 2.5, 2)) FROM src LIMIT 1;  -- 2\n  SELECT _FUNC_(ST_LineString('linestring z (1.5 2.5 2, 3.0 2.2 1)')) FROM src LIMIT 1;  -- 1\n")
public class ST_MinZ
extends ST_GeometryAccessor {
    final DoubleWritable resultDouble = new DoubleWritable();
    static final Logger LOG = LoggerFactory.getLogger((String)ST_MinZ.class.getName());

    public DoubleWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        if (!ogcGeometry.is3D()) {
            LogUtils.Log_Not3D(LOG);
            return null;
        }
        this.resultDouble.set(ogcGeometry.MinZ());
        return this.resultDouble;
    }
}

