/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;

public class GenericUDAFMkCollectionEvaluator
extends GenericUDAFEvaluator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ObjectInspector inputOI;
    private transient StandardListObjectInspector loi;
    private transient ListObjectInspector internalMergeOI;
    private BufferType bufferType;

    public GenericUDAFMkCollectionEvaluator() {
    }

    public GenericUDAFMkCollectionEvaluator(BufferType bufferType) {
        this.bufferType = bufferType;
    }

    @Override
    public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
        super.init(m, parameters);
        if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
            this.inputOI = parameters[0];
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI));
        }
        this.internalMergeOI = (ListObjectInspector)parameters[0];
        this.inputOI = this.internalMergeOI.getListElementObjectInspector();
        this.loi = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.internalMergeOI);
        return this.loi;
    }

    @Override
    public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        ((MkArrayAggregationBuffer)agg).reset();
    }

    @Override
    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        MkArrayAggregationBuffer ret = new MkArrayAggregationBuffer();
        return ret;
    }

    @Override
    public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
        assert (parameters.length == 1);
        Object p = parameters[0];
        if (p != null) {
            MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
            this.putIntoCollection(p, myagg);
        }
    }

    @Override
    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        ArrayList<Object> ret = new ArrayList<Object>(myagg.container.size());
        ret.addAll(myagg.container);
        return ret;
    }

    @Override
    public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        List partialResult = this.internalMergeOI.getList(partial);
        if (partialResult != null) {
            for (Object i : partialResult) {
                this.putIntoCollection(i, myagg);
            }
        }
    }

    @Override
    public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        MkArrayAggregationBuffer myagg = (MkArrayAggregationBuffer)agg;
        ArrayList<Object> ret = new ArrayList<Object>(myagg.container.size());
        ret.addAll(myagg.container);
        return ret;
    }

    private void putIntoCollection(Object p, MkArrayAggregationBuffer myagg) {
        Object pCopy = ObjectInspectorUtils.copyToStandardObject((Object)p, (ObjectInspector)this.inputOI);
        myagg.container.add(pCopy);
    }

    public BufferType getBufferType() {
        return this.bufferType;
    }

    public void setBufferType(BufferType bufferType) {
        this.bufferType = bufferType;
    }

    static enum BufferType {
        SET,
        LIST;

    }

    class MkArrayAggregationBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        private Collection<Object> container;

        public MkArrayAggregationBuffer() {
            if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.LIST) {
                this.container = new ArrayList<Object>();
            } else if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.SET) {
                this.container = new LinkedHashSet<Object>();
            } else {
                throw new RuntimeException("Buffer type unknown");
            }
        }

        private void reset() {
            if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.LIST) {
                this.container.clear();
            } else if (GenericUDAFMkCollectionEvaluator.this.bufferType == BufferType.SET) {
                this.container = new LinkedHashSet<Object>(this.container.size());
            } else {
                throw new RuntimeException("Buffer type unknown");
            }
        }
    }
}

