/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseProduct
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger((String)DatabaseProduct.class.getName());
    private static final Class<Exception>[] unrecoverableExceptions = new Class[]{SQLIntegrityConstraintViolationException.class, DeadlineException.class};
    private static final ReentrantLock derbyLock = new ReentrantLock(true);
    public static DbType dbType;
    private static DatabaseProduct theDatabaseProduct;
    Configuration myConf;
    private String productName;
    public static final String DERBY_NAME = "derby";
    public static final String SQL_SERVER_NAME = "sqlserver";
    public static final String MYSQL_NAME = "mysql";
    public static final String MARIADB_NAME = "mariadb";
    public static final String POSTGRESQL_NAME = "postgresql";
    public static final String ORACLE_NAME = "oracle";
    public static final String UNDEFINED_NAME = "other";
    private static final EnumMap<DbType, String> DB_EPOCH_FN;
    private static final EnumMap<DbType, String> DB_SEED_FN;

    protected DatabaseProduct() {
    }

    public static DatabaseProduct determineDatabaseProduct(DataSource connPool, Configuration conf) {
        DatabaseProduct databaseProduct;
        block8: {
            Connection conn = connPool.getConnection();
            try {
                String s = conn.getMetaData().getDatabaseProductName();
                databaseProduct = DatabaseProduct.determineDatabaseProduct(s, conf);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Unable to get database product name", e);
                }
            }
            conn.close();
        }
        return databaseProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseProduct determineDatabaseProduct(String productName, Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration is null");
        boolean isExternal = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_CUSTOM_RDBMS);
        if (theDatabaseProduct != null) {
            DbType dbt = DatabaseProduct.getDbType(productName);
            if (isExternal) {
                dbt = DbType.CUSTOM;
            }
            Preconditions.checkState((dbType == dbt ? 1 : 0) != 0);
            return theDatabaseProduct;
        }
        Class<DatabaseProduct> clazz = DatabaseProduct.class;
        synchronized (DatabaseProduct.class) {
            if (productName == null) {
                productName = UNDEFINED_NAME;
            }
            DbType dbt = DatabaseProduct.getDbType(productName);
            if (theDatabaseProduct == null) {
                if (isExternal) {
                    String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CUSTOM_RDBMS_CLASSNAME);
                    if (className != null) {
                        try {
                            theDatabaseProduct = (DatabaseProduct)ReflectionUtils.newInstance(Class.forName(className), (Configuration)conf);
                            LOG.info(String.format("Using custom RDBMS %s", className));
                            dbt = DbType.CUSTOM;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Caught exception instantiating custom database product", e);
                        }
                    } else {
                        throw new RuntimeException("Unexpected: metastore.use.custom.database.product was set, but metastore.custom.database.product.classname was not");
                    }
                }
                if (theDatabaseProduct == null) {
                    theDatabaseProduct = new DatabaseProduct();
                }
                dbType = dbt;
                DatabaseProduct.theDatabaseProduct.productName = productName;
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return theDatabaseProduct;
        }
    }

    private static DbType getDbType(String productName) {
        DbType dbt = (productName = productName.replaceAll("\\s+", "").toLowerCase()).contains(DERBY_NAME) ? DbType.DERBY : (productName.contains(SQL_SERVER_NAME) ? DbType.SQLSERVER : (productName.contains(MYSQL_NAME) || productName.contains(MARIADB_NAME) ? DbType.MYSQL : (productName.contains(ORACLE_NAME) ? DbType.ORACLE : (productName.contains(POSTGRESQL_NAME) ? DbType.POSTGRES : DbType.UNDEFINED))));
        return dbt;
    }

    public static boolean isRecoverableException(Throwable t) {
        return Stream.of(unrecoverableExceptions).allMatch(ex -> ExceptionUtils.indexOfType((Throwable)t, (Class)ex) < 0);
    }

    public final boolean isDERBY() {
        return dbType == DbType.DERBY;
    }

    public final boolean isMYSQL() {
        return dbType == DbType.MYSQL;
    }

    public final boolean isORACLE() {
        return dbType == DbType.ORACLE;
    }

    public final boolean isSQLSERVER() {
        return dbType == DbType.SQLSERVER;
    }

    public final boolean isPOSTGRES() {
        return dbType == DbType.POSTGRES;
    }

    public final boolean isCUSTOM() {
        return dbType == DbType.CUSTOM;
    }

    public final boolean isUNDEFINED() {
        return dbType == DbType.UNDEFINED;
    }

    public boolean isDeadlock(SQLException e) {
        return e instanceof SQLTransactionRollbackException || (this.isMYSQL() || this.isPOSTGRES() || this.isSQLSERVER() || this.isCUSTOM()) && "40001".equals(e.getSQLState()) || this.isPOSTGRES() && "40P01".equals(e.getSQLState()) || this.isORACLE() && e.getMessage() != null && (e.getMessage().contains("deadlock detected") || e.getMessage().contains("can't serialize access for this transaction"));
    }

    public boolean isTableNotExistsError(Throwable t) {
        SQLException e = TxnUtils.getSqlException(t);
        return this.isPOSTGRES() && "42P01".equalsIgnoreCase(e.getSQLState()) || this.isMYSQL() && "42S02".equalsIgnoreCase(e.getSQLState()) || this.isORACLE() && "42000".equalsIgnoreCase(e.getSQLState()) && e.getMessage().contains("ORA-00942") || this.isSQLSERVER() && "S0002".equalsIgnoreCase(e.getSQLState()) && e.getMessage().contains("Invalid object") || this.isDERBY() && "42X05".equalsIgnoreCase(e.getSQLState());
    }

    public String toVarChar(String column) {
        switch (dbType) {
            case DERBY: {
                return String.format("CAST(%s AS VARCHAR(4000))", column);
            }
            case ORACLE: {
                return String.format("to_char(%s)", column);
            }
        }
        return column;
    }

    protected boolean needsInBatching() {
        return this.isORACLE() || this.isSQLSERVER();
    }

    protected boolean hasJoinOperationOrderBug() {
        return this.isDERBY() || this.isORACLE() || this.isPOSTGRES();
    }

    public String getHiveSchemaPostfix() {
        switch (dbType) {
            case SQLSERVER: {
                return "mssql";
            }
            case DERBY: 
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: 
            case CUSTOM: {
                return dbType.name().toLowerCase();
            }
        }
        return null;
    }

    @VisibleForTesting
    public static void reset() {
        theDatabaseProduct = null;
    }

    protected String toDate(String tableValue) {
        if (this.isORACLE()) {
            return "TO_DATE(" + tableValue + ", 'YYYY-MM-DD')";
        }
        return "cast(" + tableValue + " as date)";
    }

    protected String toTimestamp(String tableValue) {
        if (this.isORACLE()) {
            return "TO_TIMESTAMP(" + tableValue + ", 'YYYY-MM-DD HH24:mi:ss')";
        }
        if (this.isSQLSERVER()) {
            return "CONVERT(DATETIME, " + tableValue + ")";
        }
        return "cast(" + tableValue + " as TIMESTAMP)";
    }

    public String getPrepareTxnStmt() {
        if (this.isMYSQL()) {
            return "SET @@session.sql_mode=ANSI_QUOTES";
        }
        return null;
    }

    public String getTxnSeedFn(long seedTxnId) {
        return String.format(DB_SEED_FN.get((Object)dbType), seedTxnId);
    }

    public String getMillisAfterEpochFn() throws MetaException {
        String epochFn = DB_EPOCH_FN.get((Object)dbType);
        if (epochFn != null) {
            return epochFn;
        }
        String msg = "Unknown database product: " + dbType.toString();
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String getDBTime() throws MetaException {
        return switch (dbType) {
            case DbType.DERBY, DbType.CUSTOM -> "values current_timestamp";
            case DbType.SQLSERVER, DbType.MYSQL, DbType.POSTGRES -> "select current_timestamp";
            case DbType.ORACLE -> "select current_timestamp from dual";
            default -> {
                String msg = "Unknown database product: " + dbType.toString();
                LOG.error(msg);
                throw new MetaException(msg);
            }
        };
    }

    public String isWithinCheckInterval(String expr, long intervalInSeconds) throws MetaException {
        return switch (dbType) {
            case DbType.DERBY, DbType.CUSTOM -> " {fn TIMESTAMPDIFF(sql_tsi_second, " + expr + ", current_timestamp)} <= " + intervalInSeconds;
            case DbType.MYSQL, DbType.POSTGRES -> expr + " >= current_timestamp - interval '" + intervalInSeconds + "' second";
            case DbType.SQLSERVER -> "DATEDIFF(second, " + expr + ", current_timestamp) <= " + intervalInSeconds;
            case DbType.ORACLE -> expr + " >= current_timestamp - numtodsinterval(" + intervalInSeconds + " , 'second')";
            default -> {
                String msg = "Unknown database product: " + dbType.toString();
                LOG.error(msg);
                throw new MetaException(msg);
            }
        };
    }

    public String addForUpdateClause(String selectStatement) throws MetaException {
        switch (dbType) {
            case DERBY: {
                return selectStatement;
            }
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: 
            case CUSTOM: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                String modifier = " with (updlock)";
                int wherePos = selectStatement.toUpperCase().indexOf(" WHERE ");
                if (wherePos < 0) {
                    return selectStatement + modifier;
                }
                return selectStatement.substring(0, wherePos) + modifier + selectStatement.substring(wherePos, selectStatement.length());
            }
        }
        String msg = "Unrecognized database product name <" + dbType + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        switch (dbType) {
            case DERBY: 
            case CUSTOM: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + dbType + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String lockTable(String txnLockTable, boolean shared) throws MetaException {
        switch (dbType) {
            case MYSQL: {
                return "SELECT  \"TXN_LOCK\" FROM \"" + txnLockTable + "\" " + (shared ? "LOCK IN SHARE MODE" : "FOR UPDATE");
            }
            case DERBY: 
            case ORACLE: 
            case POSTGRES: 
            case CUSTOM: {
                return "LOCK TABLE \"" + txnLockTable + "\" IN " + (shared ? "SHARE" : "EXCLUSIVE") + " MODE";
            }
            case SQLSERVER: {
                return "SELECT * FROM \"" + txnLockTable + "\" WITH (" + (shared ? "TABLOCK" : "TABLOCKX") + ", HOLDLOCK)";
            }
        }
        String msg = "Unrecognized database product name <" + dbType + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public List<String> getResetTxnSequenceStmts() {
        ArrayList<String> stmts = new ArrayList<String>();
        switch (dbType) {
            case DERBY: 
            case CUSTOM: {
                stmts.add("ALTER TABLE \"TXNS\" ALTER \"TXN_ID\" RESTART WITH 1");
                stmts.add("INSERT INTO \"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\")  VALUES(0, 'c', 0, 0, '', '')");
                break;
            }
            case MYSQL: {
                stmts.add("ALTER TABLE \"TXNS\" AUTO_INCREMENT=1");
                stmts.add("SET SQL_MODE='NO_AUTO_VALUE_ON_ZERO,ANSI_QUOTES'");
                stmts.add("INSERT INTO \"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\")  VALUES(0, 'c', 0, 0, '', '')");
                break;
            }
            case POSTGRES: {
                stmts.add("INSERT INTO \"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\")  VALUES(0, 'c', 0, 0, '', '')");
                stmts.add("ALTER SEQUENCE \"TXNS_TXN_ID_seq\" RESTART");
                break;
            }
            case ORACLE: {
                stmts.add("ALTER TABLE \"TXNS\" MODIFY \"TXN_ID\" GENERATED BY DEFAULT AS IDENTITY (START WITH 1)");
                stmts.add("INSERT INTO \"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\")  VALUES(0, 'c', 0, 0, '_', '_')");
                break;
            }
            case SQLSERVER: {
                stmts.add("DBCC CHECKIDENT ('txns', RESEED, 0)");
                stmts.add("SET IDENTITY_INSERT TXNS ON");
                stmts.add("INSERT INTO \"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\")  VALUES(0, 'c', 0, 0, '', '')");
                break;
            }
        }
        return stmts;
    }

    public String getTruncateStatement(String name) {
        if (this.isPOSTGRES() || this.isMYSQL()) {
            return "DELETE FROM \"" + name + "\"";
        }
        return "DELETE FROM " + name;
    }

    public boolean supportsGetGeneratedKeys() throws MetaException {
        switch (dbType) {
            case DERBY: 
            case SQLSERVER: 
            case CUSTOM: {
                return false;
            }
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: {
                return true;
            }
        }
        String msg = "Unknown database product: " + dbType.toString();
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public boolean isDuplicateKeyError(Throwable t) {
        SQLException sqlEx = TxnUtils.getSqlException(t);
        switch (dbType) {
            case DERBY: 
            case CUSTOM: {
                if (!"23505".equals(sqlEx.getSQLState())) break;
                return true;
            }
            case MYSQL: {
                if (sqlEx.getErrorCode() != 1022 && sqlEx.getErrorCode() != 1062 && sqlEx.getErrorCode() != 1586 || !"23000".equals(sqlEx.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (sqlEx.getErrorCode() != 2627 && sqlEx.getErrorCode() != 2601 || !"23000".equals(sqlEx.getSQLState())) break;
                return true;
            }
            case ORACLE: {
                if (sqlEx.getErrorCode() != 1 || !"23000".equals(sqlEx.getSQLState())) break;
                return true;
            }
            case POSTGRES: {
                if (!"23505".equals(sqlEx.getSQLState())) break;
                return true;
            }
            default: {
                String msg = sqlEx.getMessage() + " (SQLState=" + sqlEx.getSQLState() + ", ErrorCode=" + sqlEx.getErrorCode() + ")";
                throw new IllegalArgumentException("Unexpected DB type: " + dbType + "; " + msg);
            }
        }
        return false;
    }

    public List<String> createInsertValuesStmt(String tblColumns, List<String> rows, List<Integer> rowsCountInStmts, Configuration conf) {
        ArrayList<String> insertStmts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int numRowsInCurrentStmt = 0;
        switch (dbType) {
            case ORACLE: {
                if (rows.size() > 1) {
                    for (int numRows = 0; numRows < rows.size(); ++numRows) {
                        if (numRows % MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                            if (numRows > 0) {
                                sb.append(" select * from dual");
                                insertStmts.add(sb.toString());
                                if (rowsCountInStmts != null) {
                                    rowsCountInStmts.add(numRowsInCurrentStmt);
                                }
                                numRowsInCurrentStmt = 0;
                            }
                            sb.setLength(0);
                            sb.append("insert all ");
                        }
                        sb.append("into ").append(tblColumns).append(" values(").append(rows.get(numRows)).append(") ");
                        ++numRowsInCurrentStmt;
                    }
                    sb.append("select * from dual");
                    insertStmts.add(sb.toString());
                    if (rowsCountInStmts != null) {
                        rowsCountInStmts.add(numRowsInCurrentStmt);
                    }
                    return insertStmts;
                }
            }
            case DERBY: 
            case SQLSERVER: 
            case MYSQL: 
            case POSTGRES: 
            case CUSTOM: {
                for (int numRows = 0; numRows < rows.size(); ++numRows) {
                    if (numRows % MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                        if (numRows > 0) {
                            insertStmts.add(sb.substring(0, sb.length() - 1));
                            if (rowsCountInStmts != null) {
                                rowsCountInStmts.add(numRowsInCurrentStmt);
                            }
                            numRowsInCurrentStmt = 0;
                        }
                        sb.setLength(0);
                        sb.append("insert into ").append(tblColumns).append(" values");
                    }
                    sb.append('(').append(rows.get(numRows)).append("),");
                    ++numRowsInCurrentStmt;
                }
                insertStmts.add(sb.substring(0, sb.length() - 1));
                if (rowsCountInStmts != null) {
                    rowsCountInStmts.add(numRowsInCurrentStmt);
                }
                return insertStmts;
            }
        }
        String msg = "Unrecognized database product name <" + dbType + ">";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    public String addEscapeCharacters(String s) {
        if (this.isMYSQL()) {
            return s.replaceAll("\\\\", "\\\\\\\\");
        }
        return s;
    }

    public Map<String, String> getDataSourceProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        switch (dbType) {
            case MYSQL: {
                map.put("allowMultiQueries", "true");
                map.put("rewriteBatchedStatements", "true");
                break;
            }
            case POSTGRES: {
                map.put("reWriteBatchedInserts", "true");
                break;
            }
        }
        return map;
    }

    public String getBatchInsertQuery(String tableName, String columns, String rowFormat, int batchCount) {
        String row;
        StringBuilder sb = new StringBuilder();
        String fixedPart = tableName + " " + columns + " values ";
        if (this.isORACLE()) {
            sb.append("insert all ");
            row = "into " + fixedPart + rowFormat + " ";
        } else {
            sb.append("insert into " + fixedPart);
            row = rowFormat + ",";
        }
        for (int i = 0; i < batchCount; ++i) {
            sb.append(row);
        }
        if (this.isORACLE()) {
            sb.append("select * from dual ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public Object getBoolean(boolean val) {
        if (this.isDERBY()) {
            return val ? "Y" : "N";
        }
        return val;
    }

    public int getMaxRows(int batch, int paramSize) {
        if (this.isSQLSERVER()) {
            int maxAllowedRows = (2100 - paramSize) / paramSize;
            return Math.min(batch, maxAllowedRows);
        }
        return batch;
    }

    public Configuration getConf() {
        return this.myConf;
    }

    public void setConf(Configuration c) {
        this.myConf = c;
    }

    public void lockInternal() {
        if (this.isDERBY()) {
            derbyLock.lock();
        }
    }

    public void unlockInternal() {
        if (this.isDERBY()) {
            derbyLock.unlock();
        }
    }

    public static boolean isDerbyOracle() {
        return dbType == DbType.DERBY || dbType == DbType.ORACLE;
    }

    public String getProductName() {
        return this.productName;
    }

    static {
        DB_EPOCH_FN = new EnumMap<DbType, String>(DbType.class){
            {
                this.put(DbType.DERBY, "{ fn timestampdiff(sql_tsi_frac_second, timestamp('" + new Timestamp(0L) + "'), current_timestamp) } / 1000000");
                this.put(DbType.CUSTOM, "{ fn timestampdiff(sql_tsi_frac_second, timestamp('" + new Timestamp(0L) + "'), current_timestamp) } / 1000000");
                this.put(DbType.MYSQL, "round(unix_timestamp(now(3)) * 1000)");
                this.put(DbType.POSTGRES, "round(extract(epoch from current_timestamp) * 1000)");
                this.put(DbType.ORACLE, "(cast(systimestamp at time zone 'UTC' as date) - date '1970-01-01')*24*60*60*1000 + cast(mod( extract( second from systimestamp ), 1 ) * 1000 as int)");
                this.put(DbType.SQLSERVER, "datediff_big(millisecond, '19700101', sysutcdatetime())");
            }
        };
        DB_SEED_FN = new EnumMap<DbType, String>(DbType.class){
            {
                this.put(DbType.DERBY, "ALTER TABLE \"TXNS\" ALTER \"TXN_ID\" RESTART WITH %s");
                this.put(DbType.CUSTOM, "ALTER TABLE \"TXNS\" ALTER \"TXN_ID\" RESTART WITH %s");
                this.put(DbType.MYSQL, "ALTER TABLE \"TXNS\" AUTO_INCREMENT = %s");
                this.put(DbType.POSTGRES, "ALTER SEQUENCE \"TXNS_TXN_ID_seq\" RESTART WITH %s");
                this.put(DbType.ORACLE, "ALTER TABLE \"TXNS\" MODIFY \"TXN_ID\" GENERATED BY DEFAULT AS IDENTITY (START WITH %s )");
                this.put(DbType.SQLSERVER, "DBCC CHECKIDENT ('txns', RESEED, %s )");
            }
        };
    }

    public static enum DbType {
        DERBY,
        MYSQL,
        POSTGRES,
        ORACLE,
        SQLSERVER,
        CUSTOM,
        UNDEFINED;

    }
}

