/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantile", value="_FUNC_(sketch, [inclusive,] fraction)", extended=" Returns a quantile value from a given ItemsSketch<String> sketch. A single value for a given fraction is returned. The optional boolean parameter 'inclusive' (default: true) determines if the result includes values less than or equal to the fraction or, if false, only values strictly less than the fraction. The fraction represents a normalized rank, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half).")
public class GetQuantileFromStringsSketchUDF
extends UDF {
    public String evaluate(BytesWritable serializedSketch, double fraction) {
        return this.evaluate(serializedSketch, true, fraction);
    }

    public String evaluate(BytesWritable serializedSketch, Boolean inclusive, double fraction) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        if (sketch.isEmpty()) {
            return null;
        }
        return (String)sketch.getQuantile(fraction, inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }
}

