/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ArrayOfDoublesSketchToValues", value="_FUNC_(sketch) Return the list of tuple values", extended="Returns associated values of a given ArrayOfDoublesSketch as rows. Each row will be N double values, where N is the number of double values kept in the sketch per key.")
public class ArrayOfDoublesSketchToValuesUDTF
extends GenericUDTF {
    PrimitiveObjectInspector inputObjectInspector;

    public StructObjectInspector initialize(ObjectInspector[] inspectors) throws UDFArgumentException {
        if (inspectors.length != 1) {
            throw new UDFArgumentException("One argument expected");
        }
        if (inspectors[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Primitive argument expected, but " + inspectors[0].getCategory().name() + " was recieved");
        }
        this.inputObjectInspector = (PrimitiveObjectInspector)inspectors[0];
        if (this.inputObjectInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentTypeException(0, "Binary value expected as the first argument, but " + this.inputObjectInspector.getPrimitiveCategory().name() + " was recieved");
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("values"), Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector)));
    }

    public void process(Object[] data) throws HiveException {
        if (data == null || data[0] == null) {
            return;
        }
        BytesWritable serializedSketch = (BytesWritable)this.inputObjectInspector.getPrimitiveWritableObject(data[0]);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            this.forward(new Object[]{ArrayOfDoublesSketchToValuesUDTF.primitivesToList(it.getValues())});
        }
    }

    public void close() throws HiveException {
    }

    static List<Double> primitivesToList(double[] array) {
        ArrayList<Double> result = new ArrayList<Double>(array.length);
        for (double item : array) {
            result.add(item);
        }
        return result;
    }
}

