/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Iterator;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.SingleCollectionExpression;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ContainerAdapter;

public class SingleCollectionLiteral
extends SingleCollectionExpression
implements SQLLiteral {
    private Object value;

    public SingleCollectionLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.value = value;
        TypeManager typeManager = mapping.getStoreManager().getNucleusContext().getTypeManager();
        ContainerAdapter containerAdapter = typeManager.getContainerAdapter(value);
        Iterator iterator = containerAdapter.iterator();
        if (iterator.hasNext()) {
            Object wrappedValue = iterator.next();
            JavaTypeMapping m = stmt.getRDBMSManager().getSQLExpressionFactory().getMappingForType(wrappedValue.getClass(), false);
            this.delegate = stmt.getSQLExpressionFactory().newLiteral(stmt, m, wrappedValue);
        } else {
            this.delegate = new NullLiteral(stmt, null, null, null);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setNotParameter() {
        throw new NucleusException("Not implemented yet.");
    }
}

