/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class DoubleArrayByteBufferConverter
implements TypeConverter<double[], ByteBuffer> {
    private static final long serialVersionUID = 2169191689430539326L;

    @Override
    public ByteBuffer toDatastoreType(double[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromDoubleArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public double[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return ArrayConversionHelper.getDoubleArrayFromByteArray(datastoreValue.array());
    }
}

