/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.sql.type.SqlTypeAssignmentRule;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeMappingRules;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTypeCoercionRule
implements SqlTypeMappingRule {
    private static final SqlTypeCoercionRule INSTANCE;
    public static final ThreadLocal<@Nullable SqlTypeCoercionRule> THREAD_PROVIDERS;
    private final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map;

    private SqlTypeCoercionRule(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public static SqlTypeCoercionRule instance() {
        return Objects.requireNonNull(THREAD_PROVIDERS.get(), "threadProviders");
    }

    public static SqlTypeCoercionRule instance(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map) {
        return new SqlTypeCoercionRule(map);
    }

    @Override
    public Map<SqlTypeName, ImmutableSet<SqlTypeName>> getTypeMapping() {
        return this.map;
    }

    static {
        THREAD_PROVIDERS = ThreadLocal.withInitial(() -> INSTANCE);
        SqlTypeMappingRules.Builder coerceRules = SqlTypeMappingRules.builder();
        coerceRules.addAll(SqlTypeAssignmentRule.instance().getTypeMapping());
        HashSet<SqlTypeName> rule = new HashSet<SqlTypeName>();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.DOUBLE);
        rule.add(SqlTypeName.CHAR);
        rule.add(SqlTypeName.VARCHAR);
        rule.add(SqlTypeName.BOOLEAN);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        coerceRules.add(SqlTypeName.TINYINT, rule);
        coerceRules.add(SqlTypeName.SMALLINT, rule);
        coerceRules.add(SqlTypeName.INTEGER, rule);
        coerceRules.add(SqlTypeName.BIGINT, rule);
        coerceRules.add(SqlTypeName.FLOAT, rule);
        coerceRules.add(SqlTypeName.REAL, rule);
        coerceRules.add(SqlTypeName.DECIMAL, rule);
        coerceRules.add(SqlTypeName.DOUBLE, rule);
        coerceRules.add(SqlTypeName.CHAR, rule);
        coerceRules.add(SqlTypeName.VARCHAR, rule);
        for (SqlTypeName exactType : SqlTypeName.EXACT_TYPES) {
            coerceRules.add(exactType, (Set<SqlTypeName>)coerceRules.copyValues(exactType).addAll(SqlTypeName.INTERVAL_TYPES).build());
        }
        for (SqlTypeName typeName : SqlTypeName.INTERVAL_TYPES) {
            coerceRules.add(typeName, (Set<SqlTypeName>)coerceRules.copyValues(typeName).add((Object)SqlTypeName.TINYINT).add((Object)SqlTypeName.SMALLINT).add((Object)SqlTypeName.INTEGER).add((Object)SqlTypeName.BIGINT).add((Object)SqlTypeName.DECIMAL).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).build());
        }
        coerceRules.add(SqlTypeName.BINARY, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.BINARY).add((Object)SqlTypeName.VARBINARY).addAll(SqlTypeName.CHAR_TYPES).build());
        coerceRules.add(SqlTypeName.VARBINARY, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.VARBINARY).add((Object)SqlTypeName.BINARY).addAll(SqlTypeName.CHAR_TYPES).build());
        coerceRules.add(SqlTypeName.VARCHAR, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.VARCHAR).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.BOOLEAN).add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).addAll(SqlTypeName.BINARY_TYPES).addAll(SqlTypeName.NUMERIC_TYPES).addAll(SqlTypeName.INTERVAL_TYPES).build());
        coerceRules.add(SqlTypeName.CHAR, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).add((Object)SqlTypeName.BOOLEAN).add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).addAll(SqlTypeName.BINARY_TYPES).addAll(SqlTypeName.NUMERIC_TYPES).addAll(SqlTypeName.INTERVAL_TYPES).build());
        coerceRules.add(SqlTypeName.BOOLEAN, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.BOOLEAN).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.NUMERIC_TYPES).build());
        coerceRules.add(SqlTypeName.DATE, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.BINARY_TYPES).build());
        coerceRules.add(SqlTypeName.TIME, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.TIME).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.BINARY_TYPES).build());
        coerceRules.add(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.BINARY_TYPES).build());
        coerceRules.add(SqlTypeName.TIMESTAMP, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.BINARY_TYPES).addAll(SqlTypeName.NUMERIC_TYPES).build());
        coerceRules.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.CHAR).add((Object)SqlTypeName.VARCHAR).addAll(SqlTypeName.BINARY_TYPES).addAll(SqlTypeName.NUMERIC_TYPES).build());
        coerceRules.add(SqlTypeName.GEOMETRY, (Set<SqlTypeName>)coerceRules.copyValues(SqlTypeName.GEOMETRY).addAll(SqlTypeName.CHAR_TYPES).build());
        INSTANCE = new SqlTypeCoercionRule(coerceRules.map);
    }
}

