/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class JSToBigIntNode
extends JavaScriptBaseNode {
    public abstract BigInt execute(Object var1);

    public final BigInt executeBigInteger(Object value) {
        return this.execute(value);
    }

    @NeverDefault
    public static JSToBigIntNode create() {
        return JSToBigIntNodeGen.create();
    }

    @NeverDefault
    public static JSToBigIntNode getUncached() {
        return JSToBigIntNodeGen.getUncached();
    }

    @Specialization
    protected static BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"!isBigInt(value)"})
    protected final BigInt doOther(Object value, @Cached(value="createHintNumber()", uncached="getUncachedHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached JSPrimitiveToBigIntNode primitiveToBigInt) {
        return primitiveToBigInt.executeBigInt(this, toPrimitiveNode.execute(value));
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class JSPrimitiveToBigIntNode
    extends JavaScriptBaseNode {
        protected JSPrimitiveToBigIntNode() {
        }

        public abstract BigInt executeBigInt(Node var1, Object var2);

        @Specialization
        protected static BigInt doBoolean(boolean value) {
            return value ? BigInt.ONE : BigInt.ZERO;
        }

        @Specialization(guards={"!value.isForeign()"})
        protected static BigInt doBigInt(BigInt value) {
            return value;
        }

        @Specialization(guards={"value.isForeign()"})
        protected static BigInt doForeignBigInt(Node node, BigInt value) {
            throw Errors.createErrorCannotConvertToBigInt(JSErrorType.TypeError, value, node);
        }

        @Specialization(guards={"isNumber(value) || isNumberLong(value)"})
        protected static BigInt doNumber(Node node, Object value) {
            throw Errors.createErrorCannotConvertToBigInt(JSErrorType.TypeError, value, node);
        }

        @Specialization(guards={"isSymbol(value) || isNullOrUndefined(value)"})
        protected static BigInt doSymbolNullOrUndefined(Node node, Object value) {
            throw Errors.createErrorCannotConvertToBigInt(JSErrorType.TypeError, value, node);
        }

        @Specialization
        protected static BigInt doString(Node node, TruffleString value) {
            try {
                return Strings.parseBigInt(value);
            }
            catch (NumberFormatException e) {
                throw Errors.createErrorCannotConvertToBigInt(JSErrorType.SyntaxError, value, node);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CoercePrimitiveToBigIntNode
    extends JavaScriptBaseNode {
        public abstract BigInt executeBigInt(Node var1, Object var2);

        @Specialization
        protected static BigInt doBoolean(boolean value) {
            return value ? BigInt.ONE : BigInt.ZERO;
        }

        @Specialization(guards={"!value.isForeign()"})
        protected static BigInt doBigInt(BigInt value) {
            return value;
        }

        @Specialization(guards={"value.isForeign()"})
        protected static BigInt doForeignBigInt(BigInt value) {
            return value.clearForeign();
        }

        @Specialization
        protected static BigInt doInteger(int value) {
            return BigInt.valueOf(value);
        }

        @Specialization
        protected static BigInt doSafeInteger(SafeInteger value) {
            return BigInt.valueOf(value.longValue());
        }

        @Specialization
        protected static BigInt doLong(long value) {
            return BigInt.valueOf(value);
        }

        @Specialization
        protected static BigInt doDouble(double value, @Cached JSNumberToBigIntNode numberToBigInt) {
            return numberToBigInt.executeBigInt(value);
        }

        @Specialization(guards={"isSymbol(value) || isNullOrUndefined(value)"})
        protected static BigInt doSymbolNullOrUndefined(Node node, Object value) {
            throw Errors.createErrorCannotConvertToBigInt(JSErrorType.TypeError, value, node);
        }

        @Specialization
        protected static BigInt doString(Node node, TruffleString value) {
            return JSPrimitiveToBigIntNode.doString(node, value);
        }
    }
}

