/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

abstract class BaseFilesTable
extends BaseMetadataTable {
    BaseFilesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = new Schema(DataFile.getType(partitionType).fields());
        if (partitionType.fields().isEmpty()) {
            schema = TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return TypeUtil.join(schema, MetricsUtil.readableMetricsSchema(this.table().schema(), schema));
    }

    private static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, filter));
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specsById;
        private final ManifestFile manifest;
        private final Schema dataTableSchema;
        private final Schema projection;

        private ManifestReadTask(Table table, ManifestFile manifest, Schema projection, Expression filter) {
            this(table.schema(), table.io(), table.specs(), manifest, projection, filter);
        }

        ManifestReadTask(Schema dataTableSchema, FileIO io, Map<Integer, PartitionSpec> specsById, ManifestFile manifest, Schema projection, Expression filter) {
            super(DataFiles.fromManifest(manifest), null, SchemaParser.toJson(projection), PartitionSpecParser.toJson(PartitionSpec.unpartitioned()), ResidualEvaluator.unpartitioned(filter));
            this.io = io;
            this.specsById = Maps.newHashMap(specsById);
            this.manifest = manifest;
            this.dataTableSchema = dataTableSchema;
            this.projection = projection;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            Types.NestedField readableMetricsField = this.projection.findField("readable_metrics");
            if (readableMetricsField == null) {
                return CloseableIterable.transform(this.files(this.projection), file -> (StructLike)((Object)file));
            }
            Schema actualProjection = this.projectionForReadableMetrics(this.projection, readableMetricsField);
            return CloseableIterable.transform(this.files(actualProjection), f -> this.withReadableMetrics((ContentFile<?>)f, readableMetricsField));
        }

        @Override
        public long estimatedRowsCount() {
            return (long)this.manifest.addedFilesCount().intValue() + (long)this.manifest.deletedFilesCount().intValue() + (long)this.manifest.existingFilesCount().intValue();
        }

        private CloseableIterable<? extends ContentFile<?>> files(Schema fileProjection) {
            return ManifestFiles.open(this.manifest, this.io, this.specsById).project(fileProjection);
        }

        private StructLike withReadableMetrics(ContentFile<?> file, Types.NestedField readableMetricsField) {
            int structSize = this.projection.columns().size();
            MetricsUtil.ReadableMetricsStruct readableMetrics = this.readableMetrics(file, readableMetricsField);
            int metricsPosition = this.projection.columns().indexOf(readableMetricsField);
            return new MetricsUtil.StructWithReadableMetrics((StructLike)((Object)file), structSize, readableMetrics, metricsPosition);
        }

        private MetricsUtil.ReadableMetricsStruct readableMetrics(ContentFile<?> file, Types.NestedField readableMetricsField) {
            Types.StructType projectedMetricType = readableMetricsField.type().asStructType();
            return MetricsUtil.readableMetricsStruct(this.dataTableSchema, file, projectedMetricType);
        }

        private Schema projectionForReadableMetrics(Schema requestedProjection, Types.NestedField readableMetricsField) {
            Set<Integer> readableMetricsIds = TypeUtil.getProjectedIds(readableMetricsField.type());
            Schema realProjection = TypeUtil.selectNot(requestedProjection, readableMetricsIds);
            Schema requiredMetricsColumns = new Schema(MetricsUtil.READABLE_METRIC_COLS.stream().map(MetricsUtil.ReadableMetricColDefinition::originalCol).collect(Collectors.toList()));
            return TypeUtil.join(realProjection, requiredMetricsColumns);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }

        FileIO io() {
            return this.io;
        }

        Map<Integer, PartitionSpec> specsById() {
            return this.specsById;
        }

        ManifestFile manifest() {
            return this.manifest;
        }

        Schema dataTableSchema() {
            return this.dataTableSchema;
        }

        Schema projection() {
            return this.projection;
        }
    }

    static abstract class BaseAllFilesTableScan
    extends BaseAllMetadataTableScan {
        protected BaseAllFilesTableScan(Table table, Schema schema, MetadataTableType tableType) {
            super(table, schema, tableType);
        }

        protected BaseAllFilesTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }

    static abstract class BaseFilesTableScan
    extends BaseMetadataTableScan {
        protected BaseFilesTableScan(Table table, Schema schema, MetadataTableType tableType) {
            super(table, schema, tableType);
        }

        protected BaseFilesTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }
}

