/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.math.BigDecimal;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class HiveIdentityPartitionConverters {
    private HiveIdentityPartitionConverters() {
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return value.toString();
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((Long)value);
            }
            case DATE: {
                return Date.ofEpochDay((int)((Integer)value));
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((Long)value).toOffsetTime();
                }
                return new Timestamp(DateTimeUtil.timestampFromMicros((Long)value));
            }
            case DECIMAL: {
                if (value.getClass().isAssignableFrom(BigDecimal.class)) {
                    return HiveDecimal.create((BigDecimal)((BigDecimal)value));
                }
                return value;
            }
            case FIXED: {
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return value;
            }
        }
        return value;
    }
}

